package com.jshx.xmdrb.dao;

/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2012-2014 Jiangsu Hongxin System Integration Co., Ltd.   */
/*                                                                        */
/* PROPRIETARY RIGHTS of Jiangsu Hongxin are involved in the 　　　　　　 */
/* subject matter of this material.  All manufacturing, reproduction, use,*/
/* and sales rights pertaining to this subject matter are governed by the */
/* license agreement. The recipient of this software implicitly accepts   */
/* the terms of the license.                                              */
/* 本软件文档资料是江苏鸿信公司的资产,任何人士阅读和使用本资料必须获得    */
/* 相应的书面授权,承担保密责任和接受相应的法律约束.                       */
/*                                                                        */
/**************************************************************************/

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.jshx.core.base.vo.Pagination;

public interface GenericDao<T, PK extends Serializable> {

	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	public Object findClassById(Class class1, String id);

	public List<T> findListById(Map<String, Object> paraMap);

	public Object findClassByObject(Class class1, String string, String id);

	public List<T> findListBySqlId(Map<String, Object> paraMap);

	public Pagination findBySqlId(Pagination page, Map<String, Object> paraMap);

	public List<T> findListByObject(Map<String, Object> paraMap);

	public void update(T obj);

	public void saveOrUpdate(T entity);

	public void deleteWithFlag(String hql);

	public Object getObjectByProperty(Class entity, String[] name,
			Object[] value);

	public void updateByHql(String hql);

	public void saveOrUpdateByHql(T entity);

	public void updateByHql(Map paraMap);

	public void updateBySql(Map paraMap);

	public Object findObjectByCombinedSql(final Map paraMap);

	public void remove(T a);

}
