package com.jshx.wwsqys.web;

import java.io.*;
import java.math.BigDecimal;
import java.sql.Blob;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;
import com.jshx.common.web.CommonAction;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.service.DxpzService;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.service.KpsjglService;
import com.jshx.module.admin.service.UserService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import com.jshx.zsdw.entity.Zsdw;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.service.WwsqysService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

public class WwsqysAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Wwsqys wwsqys = new Wwsqys();
    /**
     * 实体类
     */
    private Xmxxb xmxxb = new Xmxxb();


	private List<Wwjdclinfo> wwjdclinfos = new ArrayList<>();

	/**
	 * 业务类
	 */
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private KpsjglService kpsjglService;
	@Autowired
	private WwsqysService wwsqysService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private WwjdclinfoService wwjdclinfoService;

	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private GenericManager genericManager;
	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	private UserService userService;
	@Autowired
	private DxpzService dxpzService;



	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
    private String comment;
    private String dwdm;//单位代码-经办用
    private String wwxmly;//项目来源-经办用

	private String downFileName;// 文件下载下载文件文件名

	private InputStream downFileStream;// 文件下载，被下载文件的输入流

    private File file; //文件上传

    private String uploadName; //文件上传文件名

    private String uploadeShowName;//文件上传显示名
	/**
	 * 分页信息
	 */
	private Pagination pagination;
	private String cedizhi;
	private String ffm;
	private String  czmapzhi;


	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据--经办
	 */
	public void list() throws Exception{
		String dwdma = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		if(!(StringUtil.isNotEmpty(dwdma)&& dwdma.equals("sf")))
		{
			return;
		}

		Map<String, Object> paraMap = new HashMap<String, Object>();
		    //项目当前节点(0:待经办,1:待复核,2:已复核)
            paraMap.put("xmjd", "0");
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != wwsqys){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != wwsqys.getSqr()) && (0 < wwsqys.getSqr().trim().length())){
				paraMap.put("sqr", "%" + wwsqys.getSqr().trim() + "%");
			}
			if ((null != wwsqys.getDelFlag()) ){
				paraMap.put("delFlag", wwsqys.getDelFlag());
			}

			if ((null != wwsqys.getSqrcard()) && (0 < wwsqys.getSqrcard().trim().length())){
				paraMap.put("sqrcard", "%" + wwsqys.getSqrcard().trim() + "%");
			}

			if ((null != wwsqys.getWwsqbh()) && (0 < wwsqys.getWwsqbh().trim().length())){
				paraMap.put("wwsqbh", "%" + wwsqys.getWwsqbh().trim() + "%");
			}

			if ((null != wwsqys.getXxylb()) && (0 < wwsqys.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + wwsqys.getXxylb().trim() + "%");
			}

			if ((null != wwsqys.getJsdw()) && (0 < wwsqys.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + wwsqys.getJsdw().trim() + "%");
			}

			if ((null != wwsqys.getXmmc()) && (0 < wwsqys.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + wwsqys.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		final String filter = "id|xxylb|sqr|sqrcard|wwsqbh|bllx|gffj|jsdw|xmmc|szmj|createTime|delFlag|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		Pagination p = wwsqysService.findByPage1(new  Pagination(1,0), paraMap);
		List<Wwsqys> list = p.getListOfObject();
		list.sort(new Comparator<Wwsqys>() {
			@Override
			public int compare(Wwsqys o1, Wwsqys o2) {
				Date date1 = o1.getCreateTime();
				Date date2 = o2.getCreateTime();
				if(date1 == null)
				{
					return 1;
				}
				if(date2 == null)
				{
					return -1;
				}
				return date1.after(date2)?-1:1;
			}
		});
		List<Wwsqys> list1 = new ArrayList<>();
		int number = pagination.getPageSize();
		int size = pagination.getPageNumber();
		if(!(number*(size-1)>list.size()-1))
		{
			list1 = list.subList(number*(size-1),number*size>list.size()-1?list.size():number*size);
		}
		pagination.setListOfObject(list1);
		pagination.setList(list1);
		pagination.setTotalCount(list.size());
		convObjectToJson(pagination, config);
	}




	/**
	 * 执行查询的方法，返回json数据--复核查询方法
	 */
	public void fhlist() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		//复核各单位根据自己的单位代码做复核操作
		  if(!this.getLoginUser().getIsSuperAdmin()){
        	  String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
  			paraMap.put("zsdw", dwdm.trim());
          }
		  //项目当前节点(0:待经办,1:待复核,2:已复核)
		  paraMap.put("xmjd", "1");

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());

		if(null != wwsqys){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != wwsqys.getSqr()) && (0 < wwsqys.getSqr().trim().length())){
				paraMap.put("sqr", "%" + wwsqys.getSqr().trim() + "%");
			}

			if ((null != wwsqys.getSqrcard()) && (0 < wwsqys.getSqrcard().trim().length())){
				paraMap.put("sqrcard", "%" + wwsqys.getSqrcard().trim() + "%");
			}

			if ((null != wwsqys.getWwsqbh()) && (0 < wwsqys.getWwsqbh().trim().length())){
				paraMap.put("wwsqbh", "%" + wwsqys.getWwsqbh().trim() + "%");
			}

			if ((null != wwsqys.getXxylb()) && (0 < wwsqys.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + wwsqys.getXxylb().trim() + "%");
			}

			if ((null != wwsqys.getJsdw()) && (0 < wwsqys.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + wwsqys.getJsdw().trim() + "%");
			}

			if ((null != wwsqys.getXmmc()) && (0 < wwsqys.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + wwsqys.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		final String filter = "id|xxylb|sqr|sqrcard|wwsqbh|bllx|gffj|jsdw|xmmc|szmj|xmjd|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = wwsqysService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 执行查询的方法，返回json数据--复核查询方法
	 */
	public void fhlist2() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
		//复核各单位根据自己的单位代码做复核操作
		if(!("sf".equals(dwdm)))
		{
			paraMap.put("zsdw", dwdm.trim());
		}
		//项目当前节点(0:待经办,1:待复核,2:已复核)
		paraMap.put("xmjd", "2");

		if(pagination==null)
			pagination = new Pagination(this.getRequest());

		if(null != wwsqys){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != wwsqys.getSqr()) && (0 < wwsqys.getSqr().trim().length())){
				paraMap.put("sqr", "%" + wwsqys.getSqr().trim() + "%");
			}

			if ((null != wwsqys.getSqrcard()) && (0 < wwsqys.getSqrcard().trim().length())){
				paraMap.put("sqrcard", "%" + wwsqys.getSqrcard().trim() + "%");
			}

			if ((null != wwsqys.getWwsqbh()) && (0 < wwsqys.getWwsqbh().trim().length())){
				paraMap.put("wwsqbh", "%" + wwsqys.getWwsqbh().trim() + "%");
			}

			if ((null != wwsqys.getXxylb()) && (0 < wwsqys.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + wwsqys.getXxylb().trim() + "%");
			}

			if ((null != wwsqys.getJsdw()) && (0 < wwsqys.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + wwsqys.getJsdw().trim() + "%");
			}

			if ((null != wwsqys.getXmmc()) && (0 < wwsqys.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + wwsqys.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		final String filter = "id|xxylb|sqr|sqrcard|wwsqbh|bllx|gffj|jsdw|xmmc|szmj|erjitjdw|xkzh|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		Pagination pagination1 = new Pagination(1,0);
		pagination1 = wwsqysService.findByPage(pagination1, paraMap);

		List<Wwsqys> wwsqyss = pagination1.getListOfObject();

		List<Wwsqys> lists = new ArrayList<>();
		if( CollectionUtils.isNotEmpty(wwsqyss))
		{
			for(Wwsqys wwsqys : wwsqyss)
			{
				String xxylb = wwsqys.getXxylb();
				Xmxxb xmxxb = xmxxbService.getByXxylb(xxylb);
				if(xmxxb!=null && "1".equals(xmxxb.getLcjk()))
				{
					Map<String ,Object> paraMapSpl = new HashMap<>();
					paraMapSpl.put("xxbbh",xxylb);
					paraMapSpl.put("ysh","1");
					 List<Spjlb> list = spjlbService.findSpjlball(paraMapSpl);
					 if(CollectionUtils.isNotEmpty(list))
					lists.add(wwsqys);
				}
			}
		}
		int pageNum = pagination.getPageNumber(); //1
		int size = pagination.getPageSize();//20
		int listsize = lists.size();
		int beginIndex = listsize>=size*(pageNum-1)? size*(pageNum-1):-1;
		int endIndex = listsize<size*pageNum ? listsize-1 : size*pageNum-1 ;
		List<Wwsqys> pageLists = new ArrayList<>();
		if(beginIndex != -1)
		{
			for(int i=beginIndex ; i<=endIndex ;i++)
			{
				pageLists.add(lists.get(i));
			}
		}
		pagination.setListOfObject(pageLists);
		pagination.setList(pageLists);
		pagination.setTotalCount(lists.size());
		convObjectToJson(pagination, config);
	}

	/**
	 * 执行查询的方法，返回json数据--复核查询方法
	 */
	public void fhlist3() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();


		//复核各单位根据自己的单位代码做复核操作
		if(!this.getLoginUser().getIsSuperAdmin()){
			String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
			paraMap.put("zsdw", dwdm.trim());
		}
		//项目当前节点(0:待经办,1:待复核,2:已复核)
		paraMap.put("xmjd", "2");

		if(pagination==null)
			pagination = new Pagination(this.getRequest());

		if(null != wwsqys){
			//设置查询条件，开发人员可以在此增加过滤条件
			if ((null != wwsqys.getSqr()) && (0 < wwsqys.getSqr().trim().length())){
				paraMap.put("sqr", "%" + wwsqys.getSqr().trim() + "%");
			}

			if ((null != wwsqys.getSqrcard()) && (0 < wwsqys.getSqrcard().trim().length())){
				paraMap.put("sqrcard", "%" + wwsqys.getSqrcard().trim() + "%");
			}

			if ((null != wwsqys.getWwsqbh()) && (0 < wwsqys.getWwsqbh().trim().length())){
				paraMap.put("wwsqbh", "%" + wwsqys.getWwsqbh().trim() + "%");
			}

			if ((null != wwsqys.getXxylb()) && (0 < wwsqys.getXxylb().trim().length())){
				paraMap.put("xxylb", "%" + wwsqys.getXxylb().trim() + "%");
			}

			if ((null != wwsqys.getJsdw()) && (0 < wwsqys.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + wwsqys.getJsdw().trim() + "%");
			}

			if ((null != wwsqys.getXmmc()) && (0 < wwsqys.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + wwsqys.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
		final String filter = "id|xxylb|sqr|sqrcard|wwsqbh|bllx|gffj|jsdw|xmmc|szmj|xmjd|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = wwsqysService.findByPage(pagination, paraMap);
		convObjectToJson(pagination, config);
	}







	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != wwsqys)&&(null != wwsqys.getId()))
			wwsqys = wwsqysService.getById(wwsqys.getId());
        if((null != wwsqys)&&(null != wwsqys.getXxylb()))
         xmxxb = xmxxbService.getByXxylb(wwsqys.getXxylb());
		return VIEW;
	}


	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}
	/**
	 * 模拟通知书打印
	 */
	public String viewdy() throws Exception{
		if((null != wwsqys)&&(null != wwsqys.getId())) {
			wwsqys = wwsqysService.getById(wwsqys.getId());
//			BigDecimal ds = BigDecimal.valueOf(Double.valueOf(StringUtil.isEmpty(wwsqys.getSqdszmj())?"0":wwsqys.getSqdszmj()));
//			BigDecimal dx = BigDecimal.valueOf(Double.valueOf(StringUtil.isEmpty(wwsqys.getSqdxzmj())?"0":wwsqys.getSqdxzmj()));
//			String sfbz = getsfbz();
//			BigDecimal add = ds.add(dx).multiply(new BigDecimal(sfbz));
			getmn(wwsqys);
//			getRequest().setAttribute("commonColum",ss[1]);
//			getRequest().setAttribute("sfbz",ss[0]);
		}

		return VIEW;
	}

	private String  getsfbz()
	{
		Kpsjgl kpsjgl = kpsjglService.findbygllb("001");
		String sfbz="0";
		if(kpsjgl !=null)
		{
			sfbz = kpsjgl.getSfbz();
		}
		return sfbz;
	}

	private void  getmn(Wwsqys wwsqys)
	{
		BigDecimal ds = BigDecimal.valueOf(Double.valueOf(StringUtil.isEmpty(wwsqys.getSqdszmj())?"0":wwsqys.getSqdszmj()));
		BigDecimal dx = BigDecimal.valueOf(Double.valueOf(StringUtil.isEmpty(wwsqys.getSqdxzmj())?"0":wwsqys.getSqdxzmj()));
		String sfbz = getsfbz();
		if(wwsqys !=null && "是".equals(wwsqys.getMnsp()))
		{
			BigDecimal adddy = ds.add(dx).multiply(new BigDecimal(sfbz));
			getRequest().setAttribute("commonColumdy",adddy.toString());
			BigDecimal add = adddy.divide(new BigDecimal(10000));
			getRequest().setAttribute("commonColum",add.toString());
			getRequest().setAttribute("sfbz",sfbz);
		}
		if(wwsqys !=null && StringUtil.isNotEmpty(wwsqys.getSzmj()))
		{
			BigDecimal szmjBigd = new BigDecimal(wwsqys.getSzmj());
			BigDecimal szysjeBigd = szmjBigd.multiply(new BigDecimal(sfbz)).divide(new BigDecimal(10000));
			getRequest().setAttribute("szysje",(String.valueOf(szysjeBigd)));
		}

	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit2() throws Exception{
		view();
		String xxylbbh = wwsqys.getXxylb();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		Pagination pagination = new Pagination(1,100);
		paraMap.put("xxylb",xxylbbh);
		pagination = wwjdclinfoService.findByPage(pagination,paraMap);
		List<Wwjdclinfo> fjs =  pagination.getListOfObject();
		wwjdclinfos = fjs;
		if(CollectionUtils.isEmpty(wwjdclinfos))
		{
			return EDIT;
		}
		 HttpServletRequest request = Struts2Util.getRequest();
		 request.setAttribute("jftzs","no");
		 request.setAttribute("jfpz","no");

		for(Wwjdclinfo wwjdclinfo : wwjdclinfos)
		{
			if("缴费通知书".equals(wwjdclinfo.getFjqm()))
			{

				request.setAttribute("jftzs","yes".equals(wwjdclinfo.getIsSync())?"yes":"no");
			}
			else if("缴费凭证".equals(wwjdclinfo.getFjqm()))
			{
				request.setAttribute("jfpz","yes".equals(wwjdclinfo.getIsSync())?"yes":"no");
			}
		}
		String dwdma = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		if(!(StringUtil.isNotEmpty(dwdma)&& dwdma.equals("sf")))
		{
			request.setAttribute("issfc","no");
		}
		getmn(wwsqys);
		return EDIT;
	}


	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)){
			wwsqys.setDeptId(this.getLoginUserDepartmentId());
			wwsqys.setDelFlag(0);
			wwsqysService.save(wwsqys);
		}else{
			wwsqysService.update(wwsqys);
		}

		return RELOAD;
	}


	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != wwsqys)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到wwsqys中去

            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
    /**
     * 缴款通知书上传
	 * 先缓存至服务器
     */
    public String wwsqysSavehf2() throws Exception
	{

		String fileName1="";
		String rubiaopath ="";
		if(file!=null && StringUtil.isNotEmpty(uploadName))
		{
			//TODO 上传文件
			String path = SysPropertiesUtil.jdlj(this.getRequest())
					+ File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+wwsqys.getXxylb()+File.separator;
			rubiaopath = "wwupload"+ File.separator+"bjcl" +File.separator+wwsqys.getXxylb()+File.separator+uploadName;
			rubiaopath = rubiaopath.replaceAll("\\\\", "/").trim();
			path = path.replaceAll("\\\\", "/").trim();
			fileName1 = FileUtils.uploadFile(file,uploadName, path);
		}
		Wwjdclinfo wwjdclinfo = new Wwjdclinfo();
		wwjdclinfo.setDeptId(this.getLoginUserDepartmentId());
		wwjdclinfo.setDelFlag(0);
		wwjdclinfo.setScdz(rubiaopath);
		wwjdclinfo.setScwjm(uploadName);
		wwjdclinfo.setFjqm(uploadeShowName);
		wwjdclinfo.setWwsqbh(wwsqys.getWwsqbh());
		wwjdclinfo.setXxylb(wwsqys.getXxylb());
		//查询表中是否存在，若存在则覆盖
		Map<String, Object> paraMap = new HashMap<String, Object>();
		Pagination pagination =new Pagination(1,100);
		paraMap.put("xxylb",wwsqys.getXxylb());
		paraMap.put("fjqm",uploadeShowName);
		pagination = wwjdclinfoService.findByPage(pagination,paraMap);
		List<Wwjdclinfo> wwjdclinfos = pagination.getListOfObject();
		if(CollectionUtils.isEmpty(wwjdclinfos))
		{
			wwjdclinfoService.save(wwjdclinfo);
		}
		else
		{
			Wwjdclinfo wwjdclinfo1 = wwjdclinfos.get(0);
			wwjdclinfo1.setFjqm(uploadeShowName);
			wwjdclinfo1.setScwjm(uploadName);
			wwjdclinfo1.setScdz(rubiaopath);
			wwjdclinfoService.update(wwjdclinfo1);
		}

		return RELOAD;
    }


    //将外网申报项目存入项目信息表
    private Boolean crxmxxb(Wwsqys ww) {
    	//获取单位平方的金额
//    	String danjia=SysPropertiesUtil.getProperty("danweijine");
    	String danjia=(String) Constant.CONSTANT_MAP.get("ptf");
    	Xmxxb xmb =new Xmxxb();
    	xmb.setXxylb(ww.getXxylb());//信息一览表编号
    	xmb.setLxpw(ww.getFgwxmbm());//发改委项目编号
    	xmb.setJsdw(ww.getJsdw());//建设单位
    	xmb.setXmmc(ww.getXmmc());//项目名称
		xmb.setXkzh(ww.getXkzh());//规划许可证号
    	xmb.setJsdd(ww.getGcxmdz());//项目地址
    	xmb.setLianxiren(ww.getSqr());//联系人,申请人
    	xmb.setPhone(ww.getSqrphone());//申请人电话

		xmb.setIsdikou(ww.getIsbjdk());
    	if(!"".equals(ww.getSqdxzmj())&&null!=ww.getSqdxzmj()){
    		xmb.setJzmjdx(ww.getSqdxzmj());
    	}
    	//地上总建筑面积
    	if(null!=ww.getSqdszmj()){
    		xmb.setZjzmjds(ww.getSqdszmj());
    	}

    	//总建筑面积,预审金额
    	String mj=SysPropertiesUtil.add(ww.getSqdszmj(), ww.getSqdxzmj());//地下面积加地上面积,等于总面积
    	xmb.setZjsmj(mj);
		xmb.setYsdmj(mj);
		if("0".equals(xmb.getZjsmj())){
			xmb.setZjsmj("0");
		}else{
			String tem=SysPropertiesUtil.jinehuoqu(xmb.getZjsmj(), danjia);
			xmb.setSlmj(tem);
		}
		    //字段定义未统一.
    		xmb.setDwdm(ww.getZsdw());
    		xmb.setZsdw(zsdwService.getDwdwByzsdm(ww.getZsdw()));
    	//项目流水号
    	String lsh=genericManager.getSN("lsh");
    	xmb.setXmlsh(lsh);
    	//手动建档标识
    	xmb.setHfsz("9");
    	//监控流程状态
    	xmb.setLcjk("0");
    	xmb.setDelFlag(0);
    	xmb.setMjyj(ww.getXmly());//项目来源
    	xmb.setIsxmcx("2");

    	xmb.setZsfw(ww.getErjitjdw());

		xmb.setCkbh(ww.getCkbh());
		xmb.setJzdwdz(ww.getSqrlxdz());

		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			dwdm =StringUtil.isEmpty(xmb.getDwdm())? zsdwService.getDwdm(this.getLoginUserDepartmentId()):xmb.getDwdm();
		}

		String result = com.jshx.module.admin.web.action.CommonAction.send2wwSGXK(xmb,null,dwdm,null);
		if("false".equals(result))
		{
			return Boolean.FALSE;
		}
		if(StringUtil.isEmpty(xmb.getId()))
		{
			xmxxbService.save(xmb);
		}
		else
		{
			xmxxbService.update(xmb);
		}


    	ww.setXmxxbid( xmb.getId());
    	wwsqysService.update(ww);

		return Boolean.TRUE;
	}


	/**
	 * 外网经办复核
	 */
	public String wwsqysSavehf1() throws Exception{
		try{

			if(StringUtil.isNotEmpty(wwxmly) && wwxmly.equals("0"))
			{
				wwsqys= wwsqysService.getById(ids);
				wwsqys.setXmjd(wwxmly);
				wwsqysService.update(wwsqys);
				this.getResponse().getWriter().println("{\"result\":true}");
				return null;
			}
			else if(StringUtil.isNotEmpty(wwxmly) && wwxmly.equals("2"))
			{
				//根据ID查到实例
				wwsqys= wwsqysService.getById(ids);
				wwsqys.setWwfhyj(comment);//复核意见

				wwsqys.setWwfhr(this.getLoginUser().getDisplayName());//复核人
				wwsqys.setWwfhsj(new Date());//复核时间


				if(StringUtil.isNotEmpty(dwdm))
				{
					wwsqys.setErjitjdw(dwdm);
				}
				if(StringUtil.isNotEmpty(flag))
				{
					wwsqys.setErjitjdw(flag);
				}

				Xmxxb x=xmxxbService.getByXxylb(wwsqys.getXxylb());
				if(null==x){
					System.out.println("外网申报项目入xmxxb:"+wwsqys.getXxylb());
					Boolean aBoolean = crxmxxb(wwsqys);
					if(!aBoolean)
					{
						this.getResponse().getWriter().println("{\"result\":false}");
						return null;
					}

				}else{
					//外网申报 未划分复核的项目，外网申报复核后，导致会更改xmxxb的征收单位，征收单位在缴费受理界面查看不到划入的项目
					x.setDwdm(wwsqys.getZsdw());
					x.setZsdw(zsdwService.getDwdwByzsdm(wwsqys.getZsdw()));
					x.setHfsz("9");
					x.setZsfw(wwsqys.getErjitjdw());
					x.setXkzh(wwsqys.getXkzh());
					x.setIsdikou(wwsqys.getIsbjdk());

                    if(StringUtil.isEmpty(x.getLxpw()) )
                    {
                        x.setLxpw(wwsqys.getFgwxmbm());
                    }
                    System.out.println("内网规划的地址:"+x.getJzdwdz()+"。是否是空："+StringUtil.isEmpty(x.getJzdwdz()) );
                    if(StringUtil.isEmpty(x.getJzdwdz()) )
                    {
                        x.setJzdwdz(wwsqys.getSqrlxdz());
                    }
                    System.out.println("内网规划的地址:"+x.getJzdwdz()+"。外网传进来的地址："+wwsqys.getSqrlxdz());
					x.setCkbh(wwsqys.getCkbh());

					String dwdm = "";
					if (!this.getLoginUser().getIsSuperAdmin())
					{
						dwdm =StringUtil.isEmpty(x.getDwdm())? zsdwService.getDwdm(this.getLoginUserDepartmentId()):x.getDwdm();
					}

					String result = com.jshx.module.admin.web.action.CommonAction.send2wwSGXK(x,null,dwdm,null);
					if("false".equals(result))
					{
						this.getResponse().getWriter().println("{\"result\":false}");
						return null;
					}
					xmxxbService.update(x);

				}

				wwsqys.setXmjd(wwxmly);//该action没有表示节点的字段，借用wwxmly
				wwsqysService.update(wwsqys);//保存修改信息
				this.getResponse().getWriter().println("{\"result\":true}");
			}

		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	/**
	 * 外网经办
	 */
	public String wwsqysSavehf() throws Exception{
	    try{
	    	  //根据ID查到实例
              wwsqys= wwsqysService.getById(ids);
              wwsqys.setWwjbr(this.getLoginUser().getDisplayName());//经办人
              wwsqys.setWwjbyj(comment);//经办意见
              wwsqys.setWwjbsj(new Date());//经办时间
              wwsqys.setXmjd("1");//项目当前节点(0:待经办,1:待复核,2:已复核)
              wwsqys.setZsdw(dwdm);//单位代码-征收单位
              wwsqys.setXmly(wwxmly);//项目来源
			  wwsqys.setCkbh(flag);
			  wwsqys.setXkzh(downFileName);
              wwsqysService.update(wwsqys);//保存修改信息
			//经办完成后 发短信通知
			try {
				if (StringUtil.isNotEmpty(wwsqys.getZsdw()) && (!wwsqys.getZsdw().equals("wqr"))) {
					String phonenum=dxpzService.findbyywbm("007",wwsqys.getZsdw());
					if (StringUtil.isNotEmpty(phonenum)) {
						DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
						String content = "网上申报项目于" + dateFormat.format(new Date()) + "划入,信息一览表编号为：" + wwsqys.getXxylb() + "。请及时处理。";
						com.jshx.module.admin.web.action.CommonAction.send(content, phonenum, this.getLoginUserDepartmentId(), this.getLoginUser().getDisplayName());
					}
				}
			}catch (Exception e)
			{
				e.printStackTrace();
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 外网经办暂存经办意见
	 */
	public void zancun1()throws Exception
	{
		try{
			//根据ID查到实例
			wwsqys= wwsqysService.getById(ids);
			wwsqys.setWwjbr(this.getLoginUser().getDisplayName());//经办人
			wwsqys.setWwjbyj(comment);//经办意见
			wwsqys.setWwjbsj(new Date());//经办时间
			wwsqys.setXkzh(downFileName);
			//wwsqys.setXmjd("1");//项目当前节点(0:待经办,1:待复核,2:已复核)
			//wwsqys.setZsdw(dwdm);//单位代码-征收单位
			//wwsqys.setXmly(wwxmly);//项目来源
			wwsqys.setCkbh(flag);
			wwsqysService.update(wwsqys);//保存修改信息
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}

	}
	/**
	 * 外网复核暂存复核意见
	 */
	public void zancun2()throws Exception
	{
		try
		{
			//根据ID查到实例
			wwsqys= wwsqysService.getById(ids);
			wwsqys.setWwfhyj(comment);//复核意见
			wwsqys.setWwfhr(this.getLoginUser().getDisplayName());//复核人
			wwsqys.setWwfhsj(new Date());//复核时间
			wwsqysService.update(wwsqys);//保存修改信息
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	/**
	 * 下载附件文件
	 * @param
	 * @return
	 */
	public String download()
	{

		if (StringUtil.isNotEmpty(ids))
		{
			try
			{
				Wwjdclinfo wwjdclinfo = wwjdclinfoService.getById(ids);
				if (null != wwjdclinfo)
				{
					// 服务器路径,创建文件夹
					// 得到当前路径
					String filename = wwjdclinfo.getScwjm();
					String path = SysPropertiesUtil.jdlj(this.getRequest())
							+ File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+wwjdclinfo.getXxylb()+File.separator+filename;
					String url = path.replaceAll("\\\\", "/").trim();

					File file = new File(url);
					System.out.println(url);
					System.out.println(file.exists());
					// if (file.exists()) {
					downFileName = java.net.URLEncoder.encode(filename, "UTF-8");
					// downFileStream =
					// ServletActionContext.getServletContext().getResourceAsStream("uploads/"
					// + filename);
					InputStream inputStream = null;
					byte[] contents = null;
					try
					{
						inputStream = new FileInputStream(file);
						contents = new byte[inputStream.available()];
						inputStream.read(contents);
					} catch (FileNotFoundException e)
					{

						e.printStackTrace();
					} catch (IOException e)
					{

						e.printStackTrace();
					}
					// downFileName = java.net.URLEncoder.encode(att
					// .getAttachname(), "UTF-8");
					downFileStream = getDownLoadFileStream(contents);
					// }
				}
			} catch (Exception ex)
			{
				logger.error(ex.toString());
				throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
			}
		}
		return SUCCESS;
	}
	/**
	 * 将文件转换成输入流，提供struts下载参数
	 * @param
	 * @return
	 */
	public InputStream getDownLoadFileStream(byte[] bytes)
	{
		try
		{
			// 将得到的字节输出流转换成字节数组——>字节输入流
			downFileStream = new ByteArrayInputStream(bytes);
		} catch (Exception e)
		{
			return null;
		}
		return downFileStream;
	}



	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
		try{
			wwsqysService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	/**
	 * 同步
	 */
	public void sync() throws Exception
	{
		//若没有传过来id，返回错误
		if(StringUtil.isEmpty(ids))
		{
			this.getResponse().getWriter().println("{\"result\":false}");
			return ;
		}
		//根据信息一览表id查询办件材料表的信息
		Map<String,Object> paraMap = new HashMap<>();
		paraMap.put("xxylb",ids);
		Pagination pagination = wwjdclinfoService.findByPage(new Pagination(1,100),paraMap);
		List<Wwjdclinfo> listOfObject = pagination.getListOfObject();
		if(CollectionUtils.isEmpty(listOfObject))
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"结果件未上传！\"}");
			return ;
		}
		Wwjdclinfo wwjdclinfo1 = null;
		String flag1 = null ;
		for(Wwjdclinfo wwjdclinfo : listOfObject)
		{
			if("缴费通知书".equals(wwjdclinfo.getFjqm()))
			{
				flag1 =	wwjdclinfo.getIsSync();
				wwjdclinfo1 = wwjdclinfo;
			}
		}
		if(wwjdclinfo1 == null )
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"缴费通知书未上传！\"}");
			return ;
		}
		if("yes".equals(flag1))
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"缴费通知书已同步！\"}");
			return ;
		}
		//同步缴款通知书
		{

			//缴款书同步
			Map<String ,String> map = new HashMap<>();
			map.put("method","syncfj");
			map.put("wwsqbh",wwjdclinfo1.getWwsqbh());
			map.put("xxylb",wwjdclinfo1.getXxylb());
			map.put("fjqm",wwjdclinfo1.getFjqm());
			map.put("Scwjm",wwjdclinfo1.getScwjm());
			map.put("scdz",wwjdclinfo1.getScdz());
			map.put("issptg","A");

			map.put("sbzt", "3");//已审核
			//审核过程记录
			Map<String, Object> jkjlb = new HashMap<String, Object>();
//			jkjlb.put("xxbbh", wwsqys.getXxylb());
			jkjlb.put("xxbbh", ids);
			List<Spjlb> ls=spjlbService.findSpjlball(jkjlb);
			String csr="";//初审人
			String csyj="";//初审意见
			String fhr="";//复核人
			String fhyj="";//复核意见
			String yjfy="";//应缴金额
			if(null!=ls&&ls.size()>0){
				csr=ls.get(0).getCsr();
				csyj=ls.get(0).getCsbz();
				fhr=ls.get(0).getFhr();
				fhyj=ls.get(0).getFhbz();
				Map<String, Object> jktzmap1 = new HashMap<String, Object>();
				jktzmap1.put("slbh", ls.get(0).getSlbh());
				List<Jktzs> jklist=jktzsService.findByAll(jktzmap1);
				if(null!=jklist&&jklist.size()>0){
					yjfy=jklist.get(0).getJfje();
				}
			}
			map.put("csr", csr);
			map.put("csyj", csyj);
			map.put("fhr", fhr);
			map.put("fhyj", fhyj);
			map.put("yjfy", yjfy);

			String result = com.jshx.module.admin.web.action.CommonAction.send2ww(map,null);
			if(StringUtil.isNotEmpty(result) && result.contains("\"message\":") && result.contains("\"code\":"))
			{
				String result1 = com.jshx.module.admin.web.action.CommonAction.getValueFromJsonstr(result,"message");
				if("查询失败".equals(result1))
				{
					this.getResponse().getWriter().println("{\"result\":false,\"info\":\"\"}");
					return ;
				}
			}
			else
			{
				this.getResponse().getWriter().println("{\"result\":false,\"info\":\"\"}");
				return ;
			}
		}
		//更新表字段isSync为yes
		wwjdclinfo1.setIsSync("yes");
		wwjdclinfoService.update(wwjdclinfo1);
		this.getResponse().getWriter().println("{\"result\":true}");
	}

	/**
	 * 同步凭证
	 */
	public void syncPz() throws Exception
	{
		//若没有传过来id，返回错误
		if(StringUtil.isEmpty(ids))
		{
			this.getResponse().getWriter().println("{\"result\":false}");
			return ;
		}

		//根据信息一览表id查询办件材料表的信息
		Map<String,Object> paraMap = new HashMap<>();
		paraMap.put("xxylb",ids);
		Pagination pagination = wwjdclinfoService.findByPage(new Pagination(1,100),paraMap);
		List<Wwjdclinfo> listOfObject = pagination.getListOfObject();
		if(CollectionUtils.isEmpty(listOfObject))
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"结果件未上传！\"}");
			return ;
		}
		Wwjdclinfo wwjdclinfo2 = null;
		String flag1 = null ;
		String flag2 = null ;
		for(Wwjdclinfo wwjdclinfo : listOfObject)
		{
			if("缴费通知书".equals(wwjdclinfo.getFjqm()))
			{
				flag1 =	wwjdclinfo.getIsSync();
			}
			else if("缴费凭证".equals(wwjdclinfo.getFjqm()))
			{
				flag2 =	wwjdclinfo.getIsSync();
				wwjdclinfo2 = wwjdclinfo;
			}
		}
		if(wwjdclinfo2 == null)
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"缴费凭证未上传！\"}");
			return ;
		}
		if( "yes".equals(flag2))
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"缴费凭证已同步！\"}");
			return ;
		}
		if( !("yes".equals(flag1)))
		{
			this.getResponse().getWriter().println("{\"result\":false,\"info\":\"必须先同步缴费通知书！\"}");
			return ;
		}

		{

			//凭证同步
			Map<String ,String> mappz = new HashMap<>();
			mappz.put("method","syncpz");
			mappz.put("wwsqbh",wwjdclinfo2.getWwsqbh());
			mappz.put("xxylb",wwjdclinfo2.getXxylb());
			mappz.put("fjqm",wwjdclinfo2.getFjqm());
			mappz.put("Scwjm",wwjdclinfo2.getScwjm());
			mappz.put("scdz",wwjdclinfo2.getScdz());
			//TODO 内网缴款通知书编号  内网受理编号
			String slbh="";
			slbh=xmxxbService.getByXxylb(wwjdclinfo2.getXxylb()).getSlbh();

			String jktzsbh="";
			Map<String, Object> jktzmap = new HashMap<String, Object>();
			jktzmap.put("slbh", slbh);
			List<Jktzs> jklist=jktzsService.findByAll(jktzmap);
			if(null!=jklist&&jklist.size()>0){
				jktzsbh=jklist.get(0).getDzbh();
			}

			mappz.put("jktzsbh",jktzsbh);//内网缴款通知书编号
			mappz.put("slbh",slbh);//内网受理编号
			String result3 = com.jshx.module.admin.web.action.CommonAction.send2ww(mappz,null);

			if(StringUtil.isNotEmpty(result3) && result3.contains("\"message\":") && result3.contains("\"code\":"))
			{
				String result4 = com.jshx.module.admin.web.action.CommonAction.getValueFromJsonstr(result3,"message");
				if("查询失败".equals(result4))
				{
					this.getResponse().getWriter().println("{\"result\":false,\"info\":\"\"}");
					return ;
				}
			}
			else
			{
				this.getResponse().getWriter().println("{\"result\":false,\"info\":\"\"}");
				return ;
			}
		}
		//更新表字段isSync为yes
		wwjdclinfo2.setIsSync("yes");
		wwjdclinfoService.update(wwjdclinfo2);
		this.getResponse().getWriter().println("{\"result\":true}");

	}

	 //测试
	  public String deleteCharString0(String sourceString) {
	        String deleteString = "";
	        for (int i = 0; i < sourceString.length(); i++) {
	            if (sourceString.charAt(i) != '\"') {
	                deleteString += sourceString.charAt(i);
	            }
	        }
	        return deleteString;
	    }
	/**
	 * 测试接口map
	 */
	public String cshi() throws Exception{
		try{


	       String a= deleteCharString0(czmapzhi);
	        String[] strs = a.split("\\,");
	        Map<String, String> m = new HashMap<String, String>();
	        for(String s:strs){
	        String[] ms = s.split(":");
	        m.put(ms[0], ms[1]);
	        }
	        com.jshx.module.admin.web.action.CommonAction.ceshi(m,cedizhi,ffm);

	        this.getResponse().getWriter().println("{\"result\":true}");

		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}


	public String zipdownload()
			throws ServletException, IOException {
		String xxylb = StringUtil.isEmpty(ids)?"":ids;
		List<File> files = new ArrayList<File>();
		HttpServletRequest request = getRequest();
		HttpServletResponse response = getResponse();

		String path = SysPropertiesUtil.jdlj(this.getRequest())
				+ File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xxylb+File.separator;
		File Allfile = new File(path);
		if (Allfile.exists()) {
			File[] fileArr = Allfile.listFiles();
			for (File file2 : fileArr) {
				files.add(file2);
			}
		}

		String fileName = xxylb + ".zip";
		// 在服务器端创建打包下载的临时文件
		String outFilePath = path;

		File fileZip = new File(outFilePath + fileName);
		fileZip.createNewFile();
		// 文件输出流
		FileOutputStream outStream = new FileOutputStream(fileZip);
		// 压缩流
		ZipOutputStream toClient = new ZipOutputStream(outStream);
		//  toClient.setEncoding("gbk");
		zipFile(files, toClient);
		toClient.close();
		outStream.close();
		this.downloadFile(fileZip, response, true);
		return null;
	}

	public static void zipFile(List<File> files, ZipOutputStream outputStream) throws IOException, ServletException {
		try {
			int size = files.size();
			// 压缩列表中的文件
			for (int i = 0; i < size; i++) {
				File file = (File) files.get(i);
				zipFile(file, outputStream);
			}
		} catch (IOException e) {
			throw e;
		}
	}
	public static void zipFile(File inputFile, ZipOutputStream outputstream) throws IOException, ServletException {
		try {
			if (inputFile.exists()) {
				if (inputFile.isFile()) {
					FileInputStream inStream = new FileInputStream(inputFile);
					BufferedInputStream bInStream = new BufferedInputStream(inStream);
					ZipEntry entry = new ZipEntry(inputFile.getName());
					outputstream.putNextEntry(entry);

					final int MAX_BYTE = 10 * 1024 * 1024; // 最大的流为10M
					long streamTotal = 0; // 接受流的容量
					int streamNum = 0; // 流需要分开的数量
					int leaveByte = 0; // 文件剩下的字符数
					byte[] inOutbyte; // byte数组接受文件的数据

					streamTotal = bInStream.available(); // 通过available方法取得流的最大字符数
					streamNum = (int) Math.floor(streamTotal / MAX_BYTE); // 取得流文件需要分开的数量
					leaveByte = (int) streamTotal % MAX_BYTE; // 分开文件之后,剩余的数量

					if (streamNum > 0) {
						for (int j = 0; j < streamNum; ++j) {
							inOutbyte = new byte[MAX_BYTE];
							// 读入流,保存在byte数组
							bInStream.read(inOutbyte, 0, MAX_BYTE);
							outputstream.write(inOutbyte, 0, MAX_BYTE); // 写出流
						}
					}
					// 写出剩下的流数据
					inOutbyte = new byte[leaveByte];
					bInStream.read(inOutbyte, 0, leaveByte);
					outputstream.write(inOutbyte);
					outputstream.closeEntry(); // Closes the current ZIP entry
					// and positions the stream for
					// writing the next entry
					bInStream.close(); // 关闭
					inStream.close();
				}
			} else {
				throw new ServletException("文件不存在！");
			}
		} catch (IOException e) {
			throw e;
		}
	}

	public void downloadFile(File file,HttpServletResponse response,boolean isDelete) {
		try {
			// 以流的形式下载文件。
			BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file.getPath()));
			byte[] buffer = new byte[fis.available()];
			fis.read(buffer);
			fis.close();
			// 清空response
			response.reset();
			OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment;filename=" + new String(file.getName().getBytes("UTF-8"),"ISO-8859-1"));
			toClient.write(buffer);
			toClient.flush();
			toClient.close();
			if(isDelete)
			{
				file.delete();        //是否将生成的服务器端文件删除
			}
		}
		catch (IOException ex) {
			ex.printStackTrace();
		}
	}

	public String singleDownload(String fileName, HttpServletRequest request,
								 HttpServletResponse response)throws Exception{
		response.setCharacterEncoding("utf-8");
		response.setContentType("multipart/form-data");
		response.setHeader("Content-Disposition", "attachment;fileName="+ fileName);
		String realPath = request.getSession().getServletContext().getRealPath("/");
		String path = realPath+"upload/";
		File file = new File(path+ File.separator + fileName);
		downloadFile(file, response, false);
		return null;
	}


	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Wwsqys getWwsqys(){
		return this.wwsqys;
	}

	public void setWwsqys(Wwsqys wwsqys){
		this.wwsqys = wwsqys;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getDwdm() {
		return dwdm;
	}

	public void setDwdm(String dwdm) {
		this.dwdm = dwdm;
	}

	public String getWwxmly() {
		return wwxmly;
	}

	public void setWwxmly(String wwxmly) {
		this.wwxmly = wwxmly;
	}


	public List<Wwjdclinfo> getWwjdclinfos() {
		return wwjdclinfos;
	}

	public void setWwjdclinfos(List<Wwjdclinfo> wwjdclinfos) {
		this.wwjdclinfos = wwjdclinfos;
	}

	public String getDownFileName() {
		return downFileName;
	}

	public void setDownFileName(String downFileName) {
		this.downFileName = downFileName;
	}

	public InputStream getDownFileStream() {
		return downFileStream;
	}

	public void setDownFileStream(InputStream downFileStream) {
		this.downFileStream = downFileStream;
	}

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getUploadName() {
        return uploadName;
    }

    public void setUploadName(String uploadName) {
        this.uploadName = uploadName;
    }

    public String getUploadeShowName() {
        return uploadeShowName;
    }

    public void setUploadeShowName(String uploadeShowName) {
        this.uploadeShowName = uploadeShowName;
    }




	public String getCedizhi() {
		return cedizhi;
	}




	public void setCedizhi(String cedizhi) {
		this.cedizhi = cedizhi;
	}




	public String getFfm() {
		return ffm;
	}




	public void setFfm(String ffm) {
		this.ffm = ffm;
	}




	public String getCzmapzhi() {
		return czmapzhi;
	}




	public void setCzmapzhi(String czmapzhi) {
		this.czmapzhi = czmapzhi;
	}


    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }
}
