package com.jshx.wwsqys.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.wwsqys.entity.Wwsqys;
import com.jshx.wwsqys.dao.WwsqysDao;

@Component("wwsqysDao")
public class WwsqysDaoImpl extends BaseDaoImpl implements WwsqysDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findWwsqysByMap", paraMap, page);
	}

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findWwsqysByMapAndDelFlag", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findWwsqys(Map<String, Object> paraMap){
		return this.findListByHqlId("findWwsqysByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Wwsqys getById(String id)
	{
		return (Wwsqys)this.getObjectById(Wwsqys.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Wwsqys wwsqys)
	{
		wwsqys.setId(null);
		this.saveOrUpdateObject(wwsqys);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Wwsqys wwsqys)
	{
		this.saveOrUpdateObject(wwsqys);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Wwsqys.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Wwsqys wwsqys = (Wwsqys)this.getObjectById(Wwsqys.class, id);
		wwsqys.setDelFlag(1);
		this.saveObject(wwsqys);
	}
}
