package com.jshx.tfspb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

public class TfspbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private String name;
	private String value;
	private String bianhao;

	/**
	 * 实体类
	 */
	private Tfspb tfspb = new Tfspb();

	/**
	 * 业务类
	 */
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private TfspbService tfspbService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private GenericManager genericManager;
    @Autowired
    private PaymentVoucherHisService  paymentVoucherHisService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	
	public String shoufeichu()
	{
		tfspb =  tfspbService.getById(ids);
		
		return "shoufeichu";
	}
	
	public String qita()
	{
		tfspb =  tfspbService.getById(ids);
		
		return "qita";
	}
	
	 public void updateTfspb() throws Exception{
	    	try{
	    		tfspb= tfspbService.getById(ids);
	    		if("受理编号".equals(name))
	    		{
	    			tfspb.setSlbh(value);
				}
	    		if("一般缴款书编号".equals(name))
	    		{
					tfspb.setJksbh(value);
				}
	    		if("规划许可面积".equals(name)){
					tfspb.setGhxkmj(value);
				}
	    		if("规划许可证编号".equals(name)){
					tfspb.setGhxkzbh(value);
				}
	    		if("已缴费面积".equals(name)){
					tfspb.setJfzjmhj(value);
				}
	    		if("已缴费金额".equals(name)){
					tfspb.setYjfje(value);
				}
	    		if("应退费面积".equals(name)){
					tfspb.setTfmj(value);
				}
	    		if("应退费金额".equals(name)){
					tfspb.setTfje(value);
				}
	    		if("开户行账号".equals(name)){
					tfspb.setKhhzh(value);
				}
	            tfspbService.update(tfspb);
	            this.getResponse().getWriter().println("{\"result\":true}");
	    	}catch(Exception e){
	    		this.getResponse().getWriter().println("{\"result\":false}");
	    	}
	    	 
	    }
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		if(!this.getLoginUser().getIsSuperAdmin()){
			Zsdw zsdw=zsdwService.getzsdw(this.getLoginUserDepartmentId());
			   paraMap.put("zsdw", zsdw.getZsdw());
	        }   
		if(null != tfspb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != tfspb.getJsdw()) && (0 < tfspb.getJsdw().trim().length())){
				paraMap.put("jsdw", "%" + tfspb.getJsdw().trim() + "%");
			}

			if ((null != tfspb.getXmmc()) && (0 < tfspb.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + tfspb.getXmmc().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|jsdw|xmmc|jksbh|ghxkmj|ghxkzbh|jfzjmhj|yjfje|tfmj|tfje|linkphone|khhzh|jbr|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = tfspbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		
		if((null != tfspb)&&(null != tfspb.getId()))
			tfspb = tfspbService.getById(tfspb.getId());
		
		if(StringUtils.isEmpty(tfspb.getJksbh()))
		{
			PaymentVoucherHis phis = paymentVoucherHisService.getPayMentByorderId(tfspb.getSlbh());
			if(phis!=null)
			{
				tfspb.setJksbh(phis.getVoucherCode());
			}
		}
		if(null!=tfspb.getSuggest()&&!"".equals(tfspb.getSuggest())){
			tfspb.setSuggest(tfspb.getSuggest().replace("\n", "<br/>"));
			tfspb.setSuggest(tfspb.getSuggest().replace(" ", "&nbsp;"));
		}
		Xmxxb xmxxb =xmxxbService.getBySlbh(tfspb.getSlbh());
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
		
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			tfspb.setDeptId(this.getLoginUserDepartmentId());
			tfspb.setDelFlag(0);
			tfspbService.save(tfspb);
		}else{
			tfspbService.update(tfspb);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != tfspb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到tfspb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			tfspbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Tfspb getTfspb(){
		return this.tfspb;
	}

	public void setTfspb(Tfspb tfspb){
		this.tfspb = tfspb;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getBianhao() {
		return bianhao;
	}

	public void setBianhao(String bianhao) {
		this.bianhao = bianhao;
	}
}
