package com.jshx.tfspb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.dao.TfspbDao;

@Component("tfspbDao")
public class TfspbDaoImpl extends BaseDaoImpl implements TfspbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findTfspbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findTfspb(Map<String, Object> paraMap){
		return this.findListByHqlId("findTfspbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Tfspb getById(String id)
	{
		return (Tfspb)this.getObjectById(Tfspb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Tfspb tfspb)
	{
		tfspb.setId(null);
		this.saveOrUpdateObject(tfspb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Tfspb tfspb)
	{
		this.saveOrUpdateObject(tfspb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Tfspb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Tfspb tfspb = (Tfspb)this.getObjectById(Tfspb.class, id);
		tfspb.setDelFlag(1);
		this.saveObject(tfspb);
	}
}
