/**   
 * 说明：
 * @version： gljcy v0.1 
 * @author:Fun  
 * @date:2013-10-12 
 * 
 * @Copyright 2013 版权所有  江苏鸿信  
 */
package com.jshx.sms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import cn.com.jshx.util.Config;
import cn.com.jshx.util.Constants;

import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.SpringContextHolder;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.message.entity.JshxMessage;
import com.jshx.message.service.JshxMessageService;
import com.jshx.message.entity.JshxMessageInfo;
import com.jshx.message.service.JshxMessageInfoService;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;

/**
 * 类描述： 发送短信公共类
 * 
 * 项目名称：gljcy 类名称：SmsTool 创建人：Fun 创建时间：2013-10-12 上午10:43:34 修改人：Fun
 * 修改时间：2013-10-12 上午10:43:34 修改备注：
 * 
 * @version
 * 
 */
public class SmsTool
{

	private static final Log log = LogFactory.getLog(SmsTool.class);

	private static UserService userService = (UserService) SpringContextHolder
			.getBean("userService");

	private static JshxMessageService jshxMessageService = (JshxMessageService) SpringContextHolder
			.getBean("jshxMessageService");

	private static JshxMessageInfoService jshxMessageInfoService = (JshxMessageInfoService) SpringContextHolder
			.getBean("jshxMessageInfoService");


	/**
	 * 
	 * 方法说明：发送短信
	 * 
	 * @param phoneList：需发送的号码列表
	 * @param content：短信发送内容
	 * @param userId：发送人用户Id
	 * 
	 * @return 返回值类型
	 * @Exception 异常对象
	 * 
	 * @author:Fun
	 * @date:2013-10-12
	 */
	public static void sendSms(List<String> phoneList, String content,
			String userId)
	{
		if (userId == null || ("").equals(userId))
		{
			return;
		}

		User user = userService.findUserById(userId);
		if (user == null)
		{
			return;
		}

		sendSms(phoneList, content, user);
	}

	/**
	 * 
	 * 方法说明：发送短信
	 * 
	 * @param phoneList：需发送的号码列表
	 * @param content：短信发送内容
	 * @param userInfo：发送人用户信息
	 * 
	 * @return 返回值类型
	 * @Exception 异常对象
	 * 
	 * @author:Fun
	 * @date:2013-10-12
	 */
	public static void sendSms(List<String> phoneList, String content,
			User userInfo)
	{
		Map<String,String> smsCfg = getSMSCfg(); 
		if (null == smsCfg || smsCfg.isEmpty())
		{
			log.debug("Sms account config is error."); 
			return; 
		}
		
		// 保存短信信息
		JshxMessageInfo messageInfo = new JshxMessageInfo();
		messageInfo.setDeptCode(userInfo.getDept().getId());
		messageInfo.setDelFlag(0);
		messageInfo.setContent(content);
		jshxMessageInfoService.save(messageInfo); 
		
		//发送短信息
		if (null != phoneList && !phoneList.isEmpty())
		{
			for (String telPhone : phoneList)
			{
				JshxMessage message = new JshxMessage();
				message.setDelFlag(0);
				message.setDeptCode(userInfo.getDept().getId());
				message.setMessageid(messageInfo.getId());
				message.setMessageResult("0");
				message.setSendphone(userInfo.getMobile());
				message.setReceivephone(telPhone);
				jshxMessageService.save(message); 
				
				if (null == telPhone || "".equals(telPhone))
				{
					log.info("============接收短信手机号码为空：" + telPhone);
					continue;
				}
				
				sendMessage(message, content, telPhone, smsCfg);
			}
		}
		
	}
	
	public static void sendMessage(JshxMessage message, String smscnt, String telPhone, Map<String,String> smsCfg)
	{
		try
		{
			SMSEntry se = new SMSEntry();
			se.setId(message.getId());
			se.setContent(smscnt);
			se.setType("1");
			se.setPhoneNo(telPhone);
			se.setSxtAddress(smsCfg.get(Constants.SXT_ADDRESS));
			se.setSxtPassword(smsCfg.get(Constants.SXT_PASSWORD));
			se.setSxtPort(smsCfg.get(Constants.SXT_PORT));
			se.setSxtUser(smsCfg.get(Constants.SXT_USER));
			SMSCenter.sent(se);
		} catch (Exception e)
		{
			log.debug(e); 
			e.printStackTrace();
		}
	}
	
	public static Map<String,String> getSMSCfg()
	{
		Map<String,String> map = new HashMap<String,String>();
		//地址
        map.put(Constants.SXT_ADDRESS, SysPropertiesUtil.getProperty("SxtAddress"));	
        
        //端口
		map.put(Constants.SXT_PORT, SysPropertiesUtil.getProperty("SxtPort"));		
		
		//用户名
		map.put(Constants.SXT_USER, SysPropertiesUtil.getProperty("SxtUser"));
		
		//密码
		map.put(Constants.SXT_PASSWORD, SysPropertiesUtil.getProperty("SxtPassword"));	
		
		StringBuffer buffer = new StringBuffer();
		buffer.append("sxt_address:").append(map.get(Constants.SXT_ADDRESS)).append("\n"); 
		buffer.append("sxt_port:").append(map.get(Constants.SXT_PORT)).append("\n"); 
		buffer.append("sxt_user:").append(map.get(Constants.SXT_USER)).append("\n"); 
		
		log.info("Sms account config is:" + buffer.toString()); 
		return map;
	}
}