package com.jshx.sms;

import java.util.concurrent.DelayQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * @author : FengJingzhun
 * @version : 1.0
 * @date : 2009-5-21 9:13:12
 */
public class SMSQueue extends Thread
{
    private static final Log logger = LogFactory.getLog(SMSQueue.class);


    public static DelayQueue<SMSEntry> queue = new DelayQueue<SMSEntry>();

    public static void add(SMSEntry bean)
    {
        queue.add(bean);
    }

    @Override
    public void run()
    {
        while (true)
        {
            SMSEntry smsEntry = new SMSEntry();
            try
            {
                smsEntry = queue.take();
                smsEntry.doLogic();
                Thread.sleep(500);
            }
            catch (Exception e)
            {
                e.printStackTrace();
            	logger.error("发送消息出错！");
                logger.error(smsEntry);
                logger.error(e);
            }
        }
    }
}
