package com.jshx.sms;



import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import static java.util.concurrent.TimeUnit.NANOSECONDS;
import static java.util.concurrent.TimeUnit.SECONDS;

/**
 * <p></p>
 *
 * @author : FengJingzhun
 * @version : 1.0
 * @date : 2009-5-21 9:15:34
 */
public abstract class DelayBean implements Delayed
{
    public final long delta;

    public DelayBean()
    {
        this(0);
    }

    public DelayBean(long delayTime)
    {
        this(delayTime, SECONDS);
    }

    public DelayBean(long delayTime, TimeUnit unit)
    {
        delta = System.nanoTime() + NANOSECONDS.convert(delayTime, unit);
    }

    public long getDelay(TimeUnit unit)
    {
        return unit.convert(delta - System.nanoTime(), NANOSECONDS);
    }

    public int compareTo(Delayed o)
    {
        DelayBean that = (DelayBean) o;
        if (delta < that.delta)
        {
            return -1;
        }
        if (delta > that.delta)
        {
            return 1;
        }
        return 0;
    }

    public abstract void doLogic() throws Exception;
}
