package com.jshx.servlet;

import ideabank.common.security.IBCrypto;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.Holder;

import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.core.utils.CodeUtil;
import com.jshx.core.utils.SpringContextHolder;
import com.jshx.mobile.service.MobileManager;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.entity.UserRole;
import com.jshx.module.admin.service.UserService;
import com.sun.org.apache.xml.internal.security.utils.Base64;

//import sun.misc.*;

public class AuthenticateSrvlet extends HttpServlet {
	
	private UserService userService = (UserService)SpringContextHolder.getBean("userService");
	
	/**
	 * Constructor of the object.
	 */
	public AuthenticateSrvlet() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws IOException
	 *             if an error occurred
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		response.setContentType("text/html;charset=utf-8");
		request.setCharacterEncoding("utf-8");
		PrintWriter out = response.getWriter();
		try {
			String random = new String(request.getParameter("random").getBytes(
					"iso8859-1"), "utf-8");
			System.out.println("pin=" + random);
			String certData = new String(request.getParameter("certData")
					.getBytes("iso8859-1"), "utf-8");
			System.out.println("pin=" + certData);
			String signData = new String(request.getParameter("signData")
					.getBytes("iso8859-1"), "utf-8");
			System.out.println("pin=" + signData);
			out.println("+OK");
		} catch (Exception e) {
			out.println("-No");
			// TODO: handle exception
		}

		out.close();
	}

	/**
	 * The doPost method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to
	 * post.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws IOException
	 *             if an error occurred
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		
		request.setCharacterEncoding("utf-8");
		
		System.out.println("==AuthenticateSrvlet==");
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		DataOutputStream dos=new DataOutputStream(response.getOutputStream());

		try {
			String strRandom=request.getParameter("random");
			
			String strCertData=request.getParameter("certData");
			String strSignData=request.getParameter("signData");
			System.out.println(strRandom+"\n"+strCertData+"\n"+strSignData);
			
			byte [] random= HexDump.hexStringToByteArray(strRandom);
			byte [] certData= HexDump.hexStringToByteArray(strCertData);
			byte [] signData= HexDump.hexStringToByteArray(strSignData);
			
			IBCrypto ibc = new IBCrypto();
			String accessCode =  ibc.trusCalcAccessCode(certData);
			
			System.out.println(" accessCode=\n[" + accessCode + "]");
			Holder<String> cn = new Holder<String>();
			Holder<String> uid = new Holder<String>();
			Holder<String> name = new Holder<String>();
			Holder<String> ou = new Holder<String>();
			Holder<String> tel = new Holder<String>();
			Holder<String> o = new Holder<String>();
			Holder<String> email = new Holder<String>();
			Holder<String> dn = new Holder<String>();
			Holder<String> sn = new Holder<String>();
			
			try{
				ibc.trusCheckLoginEx(accessCode,random,signData, cn, uid, name, ou, o, tel, email, dn, sn);
			}catch (Exception e) {
				System.out.println("====trusCheckLoginEx  Exception====");
			}
				if(uid.value==null||uid.value.equals(""))
				{
					System.err.println("==uid=NULL==");
					dos.write("-NO".getBytes("GB2312"));
				}
				else 
				{
					User user = userService.findUserByLoginId(uid.value); 
					String info = "";
					if(null != user){
						info = getUserInfo(user);
					}
					System.out.println(info);
					dos.write(info.getBytes("UTF-8"));
				}
		} catch (Exception e) {
			e.printStackTrace();
			System.err.println("==Exception==");
			dos.write("-NO".getBytes());
		}
		dos.close();
	
	}

	/**
	 * Initialization of the servlet. <br>
	 * 
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init() throws ServletException {
	}
	
	private String getUserInfo(User user){
		String isAdmin = "";
		List list = user.getUserRoles();
		String strObj = "";
		int i = 0;
		if (list != null && list.size() > 0) {
			for (Object object : list) {
				UserRight userRigh = (UserRight) object;
				UserRole userRole = userRigh.getRole();
				if (i != 0) {
					strObj += ",\"roleType" + i + "\":\"" + userRole.getRoleType() + "\",\"roleCode" + i
							+ "\":\"" + userRole.getRoleCode() + "\",\"roleName" + i + "\":\""
							+ userRole.getRoleName() + "\"";
				}else
				{
					strObj = ",\"roleType\":\"" + userRole.getRoleType() + "\",\"roleCode\":\""
							+ userRole.getRoleCode() + "\",\"roleName\":\"" + userRole.getRoleName() + "\"";
				}
				i++;
			}
		}

		if (user.getMobile() == null) {
			user.setMobile("");
		}

		if (null != user && !user.getId().isEmpty()) {
			if (user.getDisplayName() == null) {
				user.setDisplayName("");
			}
			String userPic = "";

			return "{ \"message\": \"登录成功\",\"code\": \"0\",\"userId\": \"" + user.getId()
					+ "\",\"userName\": \"" + user.getLoginId() 
					+ "\",\"realName\": \"" + user.getDisplayName() 
					+ "\", \"email\": \"" + user.getEmail()
					+ "\", \"isAdmin\": \"" + isAdmin 
					+ "\", \"telephone\": \"" + user.getMobile() 
					+ "\", \"deptId\": \"" 	+ user.getDept().getId() 
					+ "\", \"deptName\": \"" + user.getDept().getDeptName()
					+ "\",\"userPic\": \""
					+ userPic + "\"" + "}";
		}
		
		return null;
	}

}
