package com.jshx.schedule.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONObject;
import org.activiti.engine.impl.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.params.CoreProtocolPNames;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.dxpz.entity.Dxpz;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.module.admin.web.action.CommonAction;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.schedule.service.Schedule1Service;
import com.jshx.sms.SMSCenter;
import com.jshx.sms.SMSEntry;
import com.jshx.sms.SMSQueue;
import com.jshx.sms.SMSQueueInitializer;
import com.jshx.sms.SmsTool;
import com.jshx.schedule.entity.Schedule1;


import java.io.IOException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.springframework.util.CollectionUtils;

public class Schedule1Action extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Schedule1 schedule1 = new Schedule1();
	private String userNames;
	private String userIds;
	public String getUserNames() {
		return userNames;
	}

	public String getUserIds() {
		return userIds;
	}

	public void setUserIds(String userIds) {
		this.userIds = userIds;
	}

	public void setUserNames(String userNames) {
		this.userNames = userNames;
	}

	/**
	 * 业务类
	 */
	@Autowired
	private Schedule1Service schedule1Service;
	@Autowired
	private UserService userService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	private String queryYearsDateStart;

	private String queryYearsDateEnd;
	
	
	


	public String getQueryYearsDateStart() {
		return queryYearsDateStart;
	}

	public void setQueryYearsDateStart(String queryYearsDateStart) {
		this.queryYearsDateStart = queryYearsDateStart;
	}

	public String getQueryYearsDateEnd() {
		return queryYearsDateEnd;
	}

	public void setQueryYearsDateEnd(String queryYearsDateEnd) {
		this.queryYearsDateEnd = queryYearsDateEnd;
	}

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		// 设置查询条件，开发人员可以在此增加过滤条件
		if (null != queryYearsDateStart){
			paraMap.put("startYearsDate", queryYearsDateStart);
		}
		if (null != queryYearsDateEnd){
			paraMap.put("endYearsDate", queryYearsDateEnd);
		}
		pagination.setPageNumber( 1);
		pagination.setPageSize(100);
		if(StringUtils.isEmpty(queryYearsDateStart) || StringUtils.isEmpty(queryYearsDateEnd))
		{
			String [] s =  getQueryPrams();
			paraMap.put("startYearsDate", s[0]);
			paraMap.put("endYearsDate", s[1]);
		}

		if(null != schedule1){
		   
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
	//	final String filter = "id|operator|startdate|event|remark|location|";
		final String filter = "id|week|noon|startdate|enddate|event|remark|operator|location|sequence|flag|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = schedule1Service.findByPage(pagination, paraMap);
		
		//取当前登录者所关联的信息
		//客户要求查询所有人的日程安排信息
//		ArrayList<Schedule1> list1 =new ArrayList<>();
		List<Schedule1> list1=pagination.getListOfObject();
//		for(Schedule1 schedule1:list){
//			if(schedule1.getUserIds()!=null&&!("".equals(schedule1.getUserIds()))){
//				if(schedule1.getUserIds().indexOf(this.getLoginUserId())!=-1){
//					list1.add(schedule1);
//				}
//			}
//		}
		//手动添加scheduel对象，构建一周的会议表的数据
        Map<Integer,Schedule1> map = new HashMap<>();
        map.put(130000,new Schedule1(8,"上",queryYearsDateStart));
        map.put(140000,new Schedule1(8,"下",queryYearsDateStart));
        map.put(10000,new Schedule1(2,"上",queryYearsDateStart));
        map.put(20000,new Schedule1(2,"下",queryYearsDateStart));
        map.put(30000,new Schedule1(3,"上",queryYearsDateStart));
        map.put(40000,new Schedule1(3,"下",queryYearsDateStart));
        map.put(50000,new Schedule1(4,"上",queryYearsDateStart));
        map.put(60000,new Schedule1(4,"下",queryYearsDateStart));
        map.put(70000,new Schedule1(5,"上",queryYearsDateStart));
        map.put(80000,new Schedule1(5,"下",queryYearsDateStart));
        map.put(90000,new Schedule1(6,"上",queryYearsDateStart));
        map.put(100000,new Schedule1(6,"下",queryYearsDateStart));
        map.put(110000,new Schedule1(7,"上",queryYearsDateStart));
        map.put(120000,new Schedule1(7,"下",queryYearsDateStart));
		//遍历查询的结果，然后替换map中的值
		Map<Integer,Integer[]> map1 = new HashMap<>();
		if(!CollectionUtils.isEmpty(list1))
		{
			int i = 0 ;
			for(Schedule1 s : list1)
			{
				i++;
				s.setExtPro(s);
				if(StringUtils.isNotEmpty(s.getStartdate()))
				{
				    String seq = s.getSequence();
					map.remove(Integer.parseInt(seq));
					map.put(Integer.parseInt(seq)+i,s.setSequByStartDate());
					int a =  Integer.valueOf(seq)/10000;
					int b  = Integer.parseInt(s.getSequence());
				    if(a%2 == 0 && (null == map1.get(a) || (null != map1.get(a) && map1.get(a)[1] <= b )))
					{
						if(null != map1.get(a) && map1.get(a)[1] == b)
						{
							b=b+1;
							s.setSequence(String.valueOf(b));
							map.put(Integer.parseInt(seq)+i,s);
						}
							Integer[] integers = {Integer.parseInt(seq)+i,b};
							map1.put(a,integers);

					}

				}

			}
		}
		for(Integer key : map1.keySet())
		{
			map.get(map1.get(key)[0]).setFlag("1");
		}

		ArrayList<Schedule1> list2 =new ArrayList<>();
		for(Integer key : map.keySet())
		{
			list2.add(map.get(key));
		}
		pagination.setList(list2);
		pagination.setTotalCount(list1.size());
		convObjectToJson(pagination, config);
	}

	public JSONArray changeToNeeded(Pagination pagination)
	{
		JSONArray jsonArray = new JSONArray();
		for(int i=0;i<7;i++)
		{
			jsonArray.add(getScheduleJSONObject("上"));
			jsonArray.add(getScheduleJSONObject("下"));
		}
		List<Schedule1> list = pagination.getListOfObject();
		for( Schedule1 s: list)
		{

		}
		return jsonArray;
	}
	public JSONObject getScheduleJSONObject(String noon)
	{
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("week"," ");
		jsonObject.put("noon",noon);
		jsonObject.put("startdate"," ");
		jsonObject.put("enddate"," ");
		jsonObject.put("event"," ");
		jsonObject.put("remark"," ");
		jsonObject.put("operator"," ");
		jsonObject.put("location"," ");
		return  jsonObject;
	}

	
	public void list2() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		// 设置查询条件，开发人员可以在此增加过滤条件
		if (null != queryYearsDateStart){
			paraMap.put("startYearsDate", queryYearsDateStart);
		}
		if (null != queryYearsDateEnd){
			paraMap.put("endYearsDate", queryYearsDateEnd);
		}

		pagination.setPageNumber( 1);
		pagination.setPageSize(100);
		if(StringUtils.isEmpty(queryYearsDateStart) || StringUtils.isEmpty(queryYearsDateEnd))
		{
			String [] s =  getQueryPrams();
			paraMap.put("startYearsDate", s[0]);
			paraMap.put("endYearsDate", s[1]);
		}
		paraMap.put("createUserID", this.getLoginUserId());
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
//		final String filter = "id|operator|startdate|event|remark|location|";
		final String filter = "id|week|noon|startdate|enddate|event|remark|operator|location|sequence|flag|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = schedule1Service.findByPage(pagination, paraMap);

		//取当前登录者所关联的信息
		Map<Integer,Integer[]> map1 = new HashMap<>();
		List<Schedule1> list1=pagination.getListOfObject();

		//手动添加scheduel对象，构建一周的会议表的数据
		Map<Integer,Schedule1> map = new HashMap<>();
        map.put(130000,new Schedule1(8,"上",queryYearsDateStart));
        map.put(140000,new Schedule1(8,"下",queryYearsDateStart));
        map.put(10000,new Schedule1(2,"上",queryYearsDateStart));
        map.put(20000,new Schedule1(2,"下",queryYearsDateStart));
        map.put(30000,new Schedule1(3,"上",queryYearsDateStart));
        map.put(40000,new Schedule1(3,"下",queryYearsDateStart));
        map.put(50000,new Schedule1(4,"上",queryYearsDateStart));
        map.put(60000,new Schedule1(4,"下",queryYearsDateStart));
        map.put(70000,new Schedule1(5,"上",queryYearsDateStart));
        map.put(80000,new Schedule1(5,"下",queryYearsDateStart));
        map.put(90000,new Schedule1(6,"上",queryYearsDateStart));
        map.put(100000,new Schedule1(6,"下",queryYearsDateStart));
        map.put(110000,new Schedule1(7,"上",queryYearsDateStart));
        map.put(120000,new Schedule1(7,"下",queryYearsDateStart));
		//遍历查询的结果，然后替换map中的值
		if(!CollectionUtils.isEmpty(list1))
		{
			int i = 0 ;
			for(Schedule1 s : list1)
			{
				i++;
				s.setExtPro(s);
				if(StringUtils.isNotEmpty(s.getStartdate()))
				{
                    String seq = s.getSequence();
					int a =  Integer.valueOf(seq)/10000;
					String hour = s.getStartdate().substring(11,13);
					String mi = s.getStartdate().substring(14,16);
					int b  = Integer.valueOf(hour+mi);
					if(a%2 == 0 && (null == map1.get(a) || (null != map1.get(a) && map1.get(a)[1] < b )))
					{
						Integer[] integers = {Integer.parseInt(seq)+i,b};
						map1.put(a,integers);
					}
                    map.remove(Integer.parseInt(seq));
                    map.put(Integer.parseInt(seq)+i,s.setSequByStartDate());
				}

			}
		}
		for(Integer key : map1.keySet())
		{
			map.get(map1.get(key)[0]).setFlag("1");
		}
		ArrayList<Schedule1> list2 =new ArrayList<>();
		for(Integer key : map.keySet())
		{
			list2.add(map.get(key));
		}
		pagination.setList(list2);
		pagination.setTotalCount(list1.size());
		convObjectToJson(pagination, config);
	}

	public String[] getQueryPrams()
	{
		String[] ss = new String[2];
		Date date = new Date();
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int i  = calendar.get(Calendar.DAY_OF_WEEK);
		i = i==1 ? 8 : i;
		calendar.add(Calendar.DAY_OF_WEEK, 2-i);
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		String s0 = df.format(calendar.getTime());
		calendar.add(Calendar.DAY_OF_WEEK, 6);
		String s1 = df.format(calendar.getTime());
		ss[0] = s0+" 00:00:00";
		ss[1] = s1+" 23:59:59";
		return ss;
	}
	
	
	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != schedule1)&&(null != schedule1.getId()))
			schedule1 = schedule1Service.getById(schedule1.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
//		List<String> pohnes = new ArrayList<String>();
	try
	{
		
		   	schedule1.setDeptId(this.getLoginUserDepartmentId());
			schedule1.setDelFlag(0);
			schedule1.setEvent(userNames);
			schedule1.setOperator(this.getLoginUser().getDisplayName());
			if("add".equals(flag))
            {
                schedule1Service.save(schedule1);
            }else
            {
                schedule1Service.update(schedule1);
            }
			String[] arr = schedule1.getUserIds().split(",");
//			for(int i=0;i<arr.length;i++)
//			{
//				User user = userService.findUserById(arr[i]);
//				pohnes.add(user.getMobile());
//			}
			     String phones="";
		                   for (String bean : arr) {
		                       User user = userService.findUserById(bean);
		                          String phone="";
		                      phone=user.getMobile()+",";
		                      phones+=phone;
		                }       
		           String content=schedule1.getStartdate()+" - "+schedule1.getEnddate()+"在"+schedule1.getLocation()+",内容为:"+schedule1.getRemark();
		              if(!"".equals(phones)){
	                      CommonAction.send(content, phones, this.getLoginUserDepartmentId(),this.getLoginUser().getDisplayName()); 

	                    }
			
//			SmsTool.sendSms(pohnes, content, this.getLoginUserId());
		
	}catch(Exception e)
	{
		e.printStackTrace();
	}
		return RELOAD;
	}
	


	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != schedule1)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到schedule1中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			schedule1Service.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Schedule1 getSchedule1(){
		return this.schedule1;
	}

	public void setSchedule1(Schedule1 schedule1){
		this.schedule1 = schedule1;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
   
}
