package com.jshx.schedule.entity;

import java.sql.Blob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.jshx.core.utils.StringUtil;
import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="SCHEDULE1")
public class Schedule1 extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 会议地点
	 */
	private String location;

	/**
	 * 操作者
	 */
	private String operator;

	/**
	 * 会议开始时间
	 */
	private String startdate;

	/**
	 * 会议结束时间
	 */
	private String enddate;

	private String week;

	private String noon;

	private String flag = "0";

	/**
	 * 参会人员
	 */
	private String event;

	/**
	 * 会议内容
	 */
	private String remark;
	
	private String userIds;

	private String sequence;
	
	public Schedule1(){
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public Schedule1(String id, String location, String operator, String startdate, String enddate, String event, String remark){
	this.id = id;
	
	this.location = location;
	
	this.operator = operator;
	
	this.startdate = startdate;
	
	this.event = event;
	
	this.remark = remark;

	this.enddate = enddate;



	String[] ss =  getWeekNoonByStartDate(startdate);
	this.week = ss[0];
	this.noon = ss[1];
	this.sequence = ss[2];

}

    public Schedule1(int week,String noon,String startdate)
	{
		String[] strings =  getWeekStrByStartDateAndWeek(startdate,week);
		this.noon = noon;
		String sequence;
		if("下".equals(noon))
		{
			sequence = String.valueOf(Integer.parseInt(strings[1])+10000);
			this.sequence = sequence;
			this.flag = "1";
		}
		else
		{
			this.sequence =strings[1];
		}
		this.week = strings[0];
	}

	public Schedule1 setExtPro(Schedule1 schedule1)
	{
		String[] strings = getWeekNoonByStartDate(schedule1.startdate);
		schedule1.sequence = strings[2];
		schedule1.noon = strings[1];
		schedule1.week = strings[0];
		return schedule1;
	}

	public String[] getWeekStrByStartDateAndWeek(String startdate,int week)
	{

		SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		SimpleDateFormat sf1 = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
		if(StringUtil.isEmpty(startdate))
		{
			startdate = sf.format(new Date());
		}
		StringBuilder weekStrBuffer = new StringBuilder();
		String[]  result = new String[2];
		String sequ = "";
		Date date = new Date();
		if(startdate.length()<12)
		{
			startdate += " 00:00:00";
		}

		try {
			if('-' == startdate.charAt(4))
			{
				date = sf.parse(startdate);
			}
			else if('/' == startdate.charAt(4))
			{
				date = sf1.parse(startdate);
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);

		int i  = calendar.get(Calendar.DAY_OF_WEEK);
		i = i==1 ? 8 : i;
		calendar.add(Calendar.DAY_OF_WEEK, week-i);
		int j  = calendar.get(Calendar.DAY_OF_WEEK);
		//默认从0-11
		String month = String.valueOf(calendar.get(Calendar.MONTH)+1);
		String day = String.valueOf(calendar.get(Calendar.DATE));
		switch(j)
		{
			case 1:
				weekStrBuffer.append("周日<br/>&#40;").append(month).append("月").append(day).append("日&#41;"); sequ="130000";break;
			case 2:
				weekStrBuffer.append("周一<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="10000";break;
			case 3:
				weekStrBuffer.append("周二<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="30000";break;
			case 4:
				weekStrBuffer.append("周三<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="50000";break;
			case 5:
				weekStrBuffer.append("周四<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="70000";break;
			case 6:
				weekStrBuffer.append("周五<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="90000";break;
			case 7:
				weekStrBuffer.append("周六<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="110000";break;
			default:
				break;
		}
		result[0] = weekStrBuffer.toString();
        result[1] = sequ;
		return result;
	}

	public String[] getWeekNoonByStartDate(String startdate)
	{
		if(StringUtil.isEmpty(startdate))
		{
			return null;
		}
		String [] wns = new String[3];
		StringBuilder week = new StringBuilder();
		String noon ="";
		String sequ ="";
		Date date = new Date();
		String month = startdate.substring(5,7);
		month = month.indexOf("0") == 0 ? month.substring(1) : month;
		String day = startdate.substring(8,10);
		day = day.indexOf("0") == 0 ? day.substring(1) : day;
		Integer hour =Integer.parseInt(startdate.substring(11,13));
		SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
		try {
			date = sf.parse(startdate);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int i  = calendar.get(Calendar.DAY_OF_WEEK);
		switch(i)
		{
			case 1:
				week.append("周日<br/>&#40;").append(month).append("月").append(day).append("日&#41;"); sequ="130000";break;
			case 2:
				week.append("周一<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="10000";break;
			case 3:
				week.append("周二<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="30000";break;
			case 4:
				week.append("周三<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="50000";break;
			case 5:
				week.append("周四<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="70000";break;
			case 6:
				week.append("周五<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="90000";break;
			case 7:
				week.append("周六<br/>&#40;").append(month).append("月").append(day).append("日&#41;");sequ="110000";break;
			default:
				break;
		}
		if(hour<12)
		{
			noon = "上";
		}
		else
		{
			noon = "下";
			sequ = String.valueOf(Integer.parseInt(sequ)+10000);
		}
		wns[0] = week.toString();
		wns[1] = noon;
		wns[2] = sequ;
 		return wns;
	}
	public Schedule1 setSequByStartDate()
	{
		String hour = this.startdate.substring(11,13);
		String mi = this.startdate.substring(14,16);
		this.sequence = String.valueOf(Integer.parseInt(this.sequence)/10000)+hour+mi;
		this.flag="0";
		return this;
	}

	public String getSequence() {
		return sequence;
	}

	public void setSequence(String sequence) {
		this.sequence = sequence;
	}

	public String getEnddate() {
		return enddate;
	}

	public void setEnddate(String enddate) {
		this.enddate = enddate;
	}

	public String getWeek() {
		return week;
	}

	public void setWeek(String week) {
		this.week = week;
	}

	public String getNoon() {
		return noon;
	}

	public void setNoon(String noon) {
		this.noon = noon;
	}

	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="LOCATION")
	public String getLocation()
	{
		return this.location;
	}

	public void setLocation(String location)
	{
		this.location = location;
	}

	@Column(name="OPERATOR")
	public String getOperator()
	{
		return this.operator;
	}

	public void setOperator(String operator)
	{
		this.operator = operator;
	}

	@Column(name="STARTDATE")
	public String getStartdate()
	{
		return this.startdate;
	}

	public void setStartdate(String startdate)
	{
		this.startdate = startdate;
	}

	@Column(name="EVENT")
	public String getEvent()
	{
		return this.event;
	}

	public void setEvent(String event)
	{
		this.event = event;
	}

	@Column(name="REMARK")
	public String getRemark()
	{
		return this.remark;
	}

	public void setRemark(String remark)
	{
		this.remark = remark;
	}

	@Column(name="USERIDS")
	public String getUserIds() {
		return userIds;
	}

	public void setUserIds(String userIds) {
		this.userIds = userIds;
	}

	
	
}
