package com.jshx.rutaskinfo.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
public class RuTaskInfo extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 流程名称
	 */
	private String procDefId;

	/**
	 * 发起人
	 */
	private String startUserId;

	/**
	 * 发起时间
	 */
	private Date startTime;

	/**
	 * 当前节点
	 */
	private String taskDefKey;

	/**
	 * 节点状态
	 */
	private String taskState;

	/**
	 * 签收时间
	 */
	private Date claimTime;

	/**
	 * 办理人
	 */
	private String assignee;

	/**
	 * 超时时间
	 */
	private Date dueDate;
	
	/*
	 * 实例Business_Key
	 */
	private String businessKey;
	
	private String procInstId;
	private String taskId;

	
	public RuTaskInfo(){
	}
	
	public RuTaskInfo(String id, String procDefId, String startUserId, Date startTime, String taskDefKey, String taskState, Date claimTime, String assignee, Date dueDate){
this.id = id;

this.procDefId = procDefId;

this.startUserId = startUserId;

this.startTime = startTime;

this.taskDefKey = taskDefKey;

this.taskState = taskState;

this.claimTime = claimTime;

this.assignee = assignee;

this.dueDate = dueDate;
}

	

	/**
	 * @return the procInstId
	 */
	public String getProcInstId() {
		return procInstId;
	}

	/**
	 * @param procInstId the procInstId to set
	 */
	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}

	/**
	 * @return the taskId
	 */
	public String getTaskId() {
		return taskId;
	}

	/**
	 * @param taskId the taskId to set
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	public String getProcDefId()
	{
		return this.procDefId;
	}

	public void setProcDefId(String procDefId)
	{
		this.procDefId = procDefId;
	}

	public String getStartUserId()
	{
		return this.startUserId;
	}

	public void setStartUserId(String startUserId)
	{
		this.startUserId = startUserId;
	}

	public Date getStartTime()
	{
		return this.startTime;
	}

	public void setStartTime(Date startTime)
	{
		this.startTime = startTime;
	}

	public String getTaskDefKey()
	{
		return this.taskDefKey;
	}

	public void setTaskDefKey(String taskDefKey)
	{
		this.taskDefKey = taskDefKey;
	}

	public String getTaskState()
	{
		return this.taskState;
	}

	public void setTaskState(String taskState)
	{
		this.taskState = taskState;
	}

	public Date getClaimTime()
	{
		return this.claimTime;
	}

	public void setClaimTime(Date claimTime)
	{
		this.claimTime = claimTime;
	}

	public String getAssignee()
	{
		return this.assignee;
	}

	public void setAssignee(String assignee)
	{
		this.assignee = assignee;
	}

	public Date getDueDate()
	{
		return this.dueDate;
	}

	public void setDueDate(Date dueDate)
	{
		this.dueDate = dueDate;
	}

	/**
	 * @return the businessKey
	 */
	public String getBusinessKey() {
		return businessKey;
	}

	/**
	 * @param businessKey the businessKey to set
	 */
	public void setBusinessKey(String businessKey) {
		this.businessKey = businessKey;
	}
	
	

}
