package com.jshx.rfdz.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rfdz.dao.RfdzDao;
import com.jshx.rfdz.entity.Rfdz;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("paymentItemRfDao")
public class RfdzDaoImpl extends BaseDaoImpl implements RfdzDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRfdzByMap", paraMap, page);
	}

	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemRf(Map<String, Object> paraMap){
		return this.findListByHqlId("findRfdzByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rfdz getById(String id)
	{
		return (Rfdz)this.getObjectById(Rfdz.class, id);
	}



	/**
	 * 保存信息
	 */
	public void save(Rfdz paymentItemRf)
	{
		paymentItemRf.setId(null);
		this.saveOrUpdateObject(paymentItemRf);
	}

	/**
	 * 修改信息
	 */
	public void update(Rfdz paymentItemRf)
	{
		this.saveOrUpdateObject(paymentItemRf);
	}

	/**
	 * 物理删除信息
	 */
	public void delete(String id)
	{
		this.removeObjectById(Rfdz.class, id);
	}

	/**
	 * 逻辑删除信息
	 */
	public void deleteWithFlag(String id)
	{
		Rfdz paymentItemRf = (Rfdz)this.getObjectById(Rfdz.class, id);
		paymentItemRf.setDelFlag(1);
		this.saveObject(paymentItemRf);
	}
}
