package com.jshx.recordvoucher.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.recordvoucher.dao.RecodeVoucherDao;
import com.jshx.recordvoucher.entity.RecodeVoucher;
import com.jshx.recordvoucher.service.RecodeVoucherService;

@Service("recodeVoucherService")
public class RecodeVoucherServiceImpl extends BaseServiceImpl implements RecodeVoucherService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("recodeVoucherDao")
	private RecodeVoucherDao recodeVoucherDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return recodeVoucherDao.findByPage(page, paraMap);
	}
	public List findall( Map<String, Object> paraMap)
	{
		return recodeVoucherDao.findRecodeVoucher(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public RecodeVoucher getById(String id)
	{
		return recodeVoucherDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(RecodeVoucher recodeVoucher)
	{
		recodeVoucherDao.save(recodeVoucher);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(RecodeVoucher recodeVoucher)
	{
		recodeVoucherDao.update(recodeVoucher);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=recodeVoucherDao.findRecodeVoucher(paraMap);
		
		recodeVoucherDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    recodeVoucherDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public RecodeVoucher getByslbh(String sequenceId, String direction) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("sequenctId", sequenceId);
		paraMap.put("direction", direction);
		paraMap.put("delFlag", 0);
		RecodeVoucher RecodeVoucher=	(RecodeVoucher) recodeVoucherDao.findObjectByFieldsMap(RecodeVoucher.class, paraMap);
		return RecodeVoucher;
	}

	@Override
	public List getsum(Map<String, Object> paraMap) {
		
		return recodeVoucherDao.findListBySqlId("recodevochersum", paraMap);
	}

	@Override
	public RecodeVoucher getBysequence(String sequenctId, String direction) {
		// TODO Auto-generated method stub
		return null;
	}
}
