package com.jshx.rebate.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.rebate.entity.Rebate;
import com.jshx.rebate.dao.RebateDao;

@Component("rebateDao")
public class RebateDaoImpl extends BaseDaoImpl implements RebateDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findRebateByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findRebate(Map<String, Object> paraMap){
		return this.findListByHqlId("findRebateByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Rebate getById(String id)
	{
		return (Rebate)this.getObjectById(Rebate.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Rebate rebate)
	{
		rebate.setId(null);
		this.saveOrUpdateObject(rebate);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Rebate rebate)
	{
		this.saveOrUpdateObject(rebate);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Rebate.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Rebate rebate = (Rebate)this.getObjectById(Rebate.class, id);
		rebate.setDelFlag(1);
		this.saveObject(rebate);
	}
}
