package com.jshx.pjjx.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.pjjx.entity.Pjjx;
import com.jshx.pjjx.dao.PjjxDao;

@Component("pjjxDao")
public class PjjxDaoImpl extends BaseDaoImpl implements PjjxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPjjxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPjjx(Map<String, Object> paraMap){
		return this.findListByHqlId("findPjjxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Pjjx getById(String id)
	{
		return (Pjjx)this.getObjectById(Pjjx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Pjjx pjjx)
	{
		pjjx.setId(null);
		this.saveOrUpdateObject(pjjx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Pjjx pjjx)
	{
		this.saveOrUpdateObject(pjjx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Pjjx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Pjjx pjjx = (Pjjx)this.getObjectById(Pjjx.class, id);
		pjjx.setDelFlag(1);
		this.saveObject(pjjx);
	}
}
