package com.jshx.paymentLq.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.billManager.entity.Indeticur;
import com.jshx.billPayment.entity.Bill;
import com.jshx.billPayment.service.BillpaymentService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.paymentLq.entity.Paymentlq;
import com.jshx.paymentLq.service.PaymentlqService;
import com.neusoft.egov.utils.billendnumber;

public class PaymentlqAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Paymentlq paymentlq = new Paymentlq();

	/**
	 * 业务类
	 */
	@Autowired
	private PaymentlqService paymentlqService;
	@Autowired
	private  BillpaymentService   billpaymentService;
	

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != paymentlq){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != paymentlq.getZsdw()) && (0 < paymentlq.getZsdw().trim().length())){
				paraMap.put("zsdw", "%" + paymentlq.getZsdw().trim() + "%");
			}

			if ((null != paymentlq.getStartno()) && (0 < paymentlq.getStartno().trim().length())){
				paraMap.put("startno", "%" + paymentlq.getStartno().trim() + "%");
			}

			if ((null != paymentlq.getEndno()) && (0 < paymentlq.getEndno().trim().length())){
				paraMap.put("endno", "%" + paymentlq.getEndno().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|zsdw|startno|endno|person|count|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = paymentlqService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != paymentlq)&&(null != paymentlq.getId()))
			paymentlq = paymentlqService.getById(paymentlq.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		//view();
		paymentlq.setSequenceId(ids);
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		Map<String, Object> paraMap = new HashMap<String, Object>();
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		
			String startNo =paymentlq.getStartno();
			int length =paymentlq.getStartno().length();
			int end = Integer.parseInt(startNo)+Integer.parseInt(paymentlq.getCount())-1;
			
			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("no", no);
				paraMap.put("sequenceID", paymentlq.getSequenceId());
				paraMap.put("isrece", 0);
				Bill Indeticur =billpaymentService.getBillByNo(paraMap);
				if(Indeticur!=null)
				{
					Indeticur.setIsrece(1);
					Indeticur.setPerson(paymentlq.getPerson());
					Indeticur.setZsdw(paymentlq.getZsdw());
					billpaymentService.update(Indeticur);
				}else
				{
					end++;
				}
			}
			paymentlq.setDeptId(this.getLoginUserDepartmentId());
			paymentlq.setDelFlag(0);
			paymentlq.setEndno(buwei(String.valueOf(end),length));
			paymentlqService.save(paymentlq);
			
		return RELOAD;
	}
	
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no;
		 return s;
	}
	
	

	public void isExit()
	{
		 JSONObject jsonObject = new JSONObject();
		 Map<String, Object> paraMap = new HashMap<String, Object>();
		 Map<String, Object> paraMap1 = new HashMap<String, Object>();
		 paraMap.put("isrece", 0);
		 paraMap1.put("isrece", 0);
		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			String count = (String) this.getRequest().getParameter("xxxx");
			String no = (String) this.getRequest().getParameter("no");
			no=buwei(no,no.length());
			paraMap.put("no", no);
			paraMap.put("sequenceID",ids);
			paraMap.put("isrece", 0);
			Bill indeticur=	billpaymentService.getBillByNo(paraMap);
			
			if(indeticur==null)
			{
				jsonObject.put("status", "y");
				jsonObject.put("info","开始号段"+no.substring(0,9)+"已经被领取或者不存在,请确认!");
				getResponse().getWriter().println(jsonObject.toString());	
			}else
			{
				paraMap1.put("sequenceID",ids);
				paraMap1.put("isrece", 0);
				int number = billpaymentService.findcountByMap(paraMap1);
				if(Integer.parseInt(count)>number)
				{
					jsonObject.put("status", "y");
					jsonObject.put("info","领取的票据张数不能超过"+number+"张");
					
					getResponse().getWriter().println(jsonObject.toString());
				}else
				{
					jsonObject.put("status", "n");
					getResponse().getWriter().println(jsonObject.toString());
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != paymentlq)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到paymentlq中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			paymentlqService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Paymentlq getPaymentlq(){
		return this.paymentlq;
	}

	public void setPaymentlq(Paymentlq paymentlq){
		this.paymentlq = paymentlq;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
