package com.jshx.paymentItemPending.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.xmxxb.entity.Xmxxb;

public interface PaymentItemPendingService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 不分页查询
	 * @param paraMap
	 * @return
	 */
	public List<PaymentItemPending> findPaymentItemPending(Map<String, Object> paraMap);
	
	/**根据受理编号查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemPending getByOrderId(String orderId);
	
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemPending getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemPending model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemPending model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);
	
	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	
	/**
	 * 
	 * 打印缴款书,入代缴库
	 * @param xmb
	 * @param jk
	 */
	public void czgl(PaymentItemPending dj,Xmxxb xmb,Jktzs jk);
	/**
	 * 直接打印项目
	 * @param dj
	 * @param xmb
	 * @param jk
	 */
	public void zjdyxg(PaymentItemPending dj,Xmxxb xmb,Jktzs jk);
}
