package com.jshx.paymentItemHis.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemHis.dao.PaymentItemHisDao;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;

@Service("paymentItemHisService")
public class PaymentItemHisServiceImpl extends BaseServiceImpl implements PaymentItemHisService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentItemHisDao")
	private PaymentItemHisDao paymentItemHisDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemHisDao.findByPage(page, paraMap);
	}

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findPaymentItemHisJoinXmxxbByMap(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemHisDao.findPaymentItemHisJoinXmxxbByMap(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemHis getById(String id)
	{
		return paymentItemHisDao.getById(id);
	}
	
	/**根据受理编号查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByOrderId(String orderId) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("slbh", orderId);
		PaymentItemHis paymentItemHis = (PaymentItemHis)paymentItemHisDao.findObjectByFieldsMap(PaymentItemHis.class, paraMap);
		return paymentItemHis;
	}
	
	/**根据项目表id查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByXmbId(String xmbzj)	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("xmbzj", xmbzj);
		PaymentItemHis paymentItemHis = (PaymentItemHis)paymentItemHisDao.findObjectByFieldsMap(PaymentItemHis.class, paraMap);
		return paymentItemHis;
	}
	
	/**根据凭证查询代缴款项目
	 * @param orderId
	 * @return
	 */
	public PaymentItemHis getByZslxdbh(String zslxdbh)	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("zslxdbh", zslxdbh);
		PaymentItemHis paymentItemHis = (PaymentItemHis)paymentItemHisDao.findObjectByFieldsMap(PaymentItemHis.class, paraMap);
		return paymentItemHis;
	}

	@Override
	public String getLastZslxdbh() {
		return null;
	}

	@Override
	public int getPzbh() {
		return paymentItemHisDao.getPzbh();
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentItemHis paymentItemHis)
	{
		paymentItemHisDao.save(paymentItemHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentItemHis paymentItemHis)
	{
		paymentItemHisDao.update(paymentItemHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentItemHisDao.findPaymentItemHis(paraMap);
		
		paymentItemHisDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    paymentItemHisDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<PaymentItemHis> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return paymentItemHisDao.findPaymentItemHis(paraMap);
	}
	@Override
	public List<PaymentItemHis> findsuoyou(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return paymentItemHisDao.findsuoyou(paraMap);
	}

}
