package com.jshx.paymentItemDelayFree.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemDelayFree.dao.PaymentItemDelayFreeDao;
import com.jshx.paymentItemDelayFree.entity.PaymentItemDelayFree;
import com.jshx.paymentItemDelayFree.service.PaymentItemDelayFreeService;

@Service("paymentItemDelayFreeService")
public class PaymentItemDelayFreeServiceImpl extends BaseServiceImpl implements PaymentItemDelayFreeService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentItemDelayFreeDao")
	private PaymentItemDelayFreeDao paymentItemDelayFreeDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemDelayFreeDao.findByPage(page, paraMap);
	}
	
	public Pagination findByPageWithSql(Pagination page, Map<String, Object> paraMap)
	{
		return paymentItemDelayFreeDao.findPageBySqlIdReturnMap("findPaymentItemDelayDetail", paraMap, page);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemDelayFree getById(String id)
	{
		return paymentItemDelayFreeDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentItemDelayFree paymentItemDelayFree)
	{
		paymentItemDelayFreeDao.save(paymentItemDelayFree);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentItemDelayFree paymentItemDelayFree)
	{
		paymentItemDelayFreeDao.update(paymentItemDelayFree);
	}
	
	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	@Transactional
	public void delete(String id)
	{
		paymentItemDelayFreeDao.removeObjectById(PaymentItemDelayFree.class, id);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentItemDelayFreeDao.findPaymentItemDelayFree(paraMap);
		
		paymentItemDelayFreeDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    paymentItemDelayFreeDao.deleteWithFlag(id);
			}
		}
	}
}
