package com.jshx.paymentItemDelay.web;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.activiti.service.ActivitiService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.paymentItemDelayFree.entity.PaymentItemDelayFree;
import com.jshx.paymentItemDelayFree.service.PaymentItemDelayFreeService;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

public class PaymentItemDelayAction extends BaseAction
{
	/**
	 * 主键ID，用于接收页面提交的主键ID信息
	 */
	private String id;
	
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private PaymentItemDelay paymentItemDelay = new PaymentItemDelay();
	
	private PaymentItemDelayFree paymentItemDelayFree = new PaymentItemDelayFree();

	/**
	 * 业务类
	 */
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	
	@Autowired
	private PaymentItemDelayFreeService paymentItemDelayFreeService;
	
	@Autowired
    private IdentityService identityService;
	
	@Autowired
    protected RuntimeService runtimeService;
	
    @Autowired
    protected TaskService taskService;
    
    @Autowired
    private ActivitiService activitiService;
	@Autowired
	private ZsdwService zsdwService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	/**
	 * 相关金额
	 */
	private String amount;
	
	/**
	 * 登记文号
	 */
	private String registNo;
	
	/**
	 * 备注
	 */
	private String remark;
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 台账处理类型
	 */
	private String type;

	/**
	 * 任务ID
	 */
	private String taskId;

	/**
	 * 审核建议
	 */
	private String comment;
	
	/**
	 * 审核结果(通过、驳回)
	 */
	private String outcome;

	/**
	 * 核销状态
	 */
	private String status;

	/**
	 * 经办意见
	 */
	private String operatorComment;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
	    if(!this.getLoginUser().getIsSuperAdmin()){
      	  String dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
			paraMap.put("dwdm", dwdm.trim());
        }
		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != paymentItemDelay){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != paymentItemDelay.getSlbh()) && (0 < paymentItemDelay.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + paymentItemDelay.getSlbh().trim() + "%");
			}

			if ((null != paymentItemDelay.getDwmc()) && (0 < paymentItemDelay.getDwmc().trim().length())){
				paraMap.put("dwmc", "%" + paymentItemDelay.getDwmc().trim() + "%");
			}

			if ((null != paymentItemDelay.getXmmc()) && (0 < paymentItemDelay.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + paymentItemDelay.getXmmc().trim() + "%");
			}
			//未核销
			if ("1".equals(status)){
				paraMap.put("status1",  status);
			}
			//已核销
			if ("2".equals(status)){
				paraMap.put("status2",  status);
			}
			
			if ((null != paymentItemDelay.getHjje()) && (0 < paymentItemDelay.getHjje().trim().length())){
				paraMap.put("hjje", paymentItemDelay.getHjje().trim());
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|slbh|dwmc|xmmc|zsdw|createTime|csmj|hjje|ysyjje|hjye|yjje|blyj|dqsj|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = paymentItemDelayService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != paymentItemDelay)&&(null != paymentItemDelay.getId()))
			paymentItemDelay = paymentItemDelayService.getById(paymentItemDelay.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			paymentItemDelay.setDeptId(this.getLoginUserDepartmentId());
			paymentItemDelay.setDelFlag(0);
			paymentItemDelayService.save(paymentItemDelay);
		}else{
			paymentItemDelayService.update(paymentItemDelay);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != paymentItemDelay)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到paymentItemDelay中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			paymentItemDelayService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	/**
	 * 跳转核销页面
	 */
	public String reimburse(){
		paymentItemDelay = paymentItemDelayService.getById(id);
		return SUCCESS;
	}
	
	/**
	 * 免缴
	 * @throws Exception
	 */
	public void free() throws Exception{
		try{
			PaymentItemDelayFree model = new PaymentItemDelayFree();
			paymentItemDelay = paymentItemDelayService.getById(id);
			model.setDelFlag(0);
			model.setRelateId(id);
			model.setFreeAmount(amount);
			model.setRemark(remark);
			if(Constant.TYPE_FREE.equals(type)){
				model.setType(Constant.TYPE_FREE);
			}else if(Constant.TYPE_OTHER.equals(type)){
				model.setType(Constant.TYPE_OTHER);
			}
			model.setRegistNo(registNo);//登记文号
			model.setDwdm(paymentItemDelay.getDwdm());//单位代码
			model.setOperatorComment(operatorComment);//经办意见
			paymentItemDelayFreeService.save(model);
    		identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
            runtimeService.startProcessInstanceByKey(Constant.PROCESS_TZCL,model.getId());//缓缴款项目主键
            this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	
	/**
	 * 台账复核界面
	 * @throws Exception
	 */
	public String toTzfh() throws Exception{
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessKey =  processInstance.getBusinessKey();
        //获取登记信息
        paymentItemDelayFree = paymentItemDelayFreeService.getById(businessKey);
        //获取关联的缓缴信息
        paymentItemDelay = paymentItemDelayService.getById(paymentItemDelayFree.getRelateId());
        List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
        ActionContext.getContext().put("outcomeList", outcomeList);
        return SUCCESS;
	}
	
	/**
	 * 台账复核提交
	 * @throws Exception
	 */
	public void submit_tzfh() throws Exception{
		try{
			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	        String businessKey =  processInstance.getBusinessKey();
	        //核销通过
	        if(Constant.OUTCOME_PASS.equals(outcome)){
		        //获取登记信息
		        paymentItemDelayFree = paymentItemDelayFreeService.getById(businessKey);
		        //获取关联的缓缴信息
		        paymentItemDelay = paymentItemDelayService.getById(paymentItemDelayFree.getRelateId());
		        //缓缴余额
		        String remainAmount = new BigDecimal(paymentItemDelay.getHjye()).subtract(new BigDecimal(paymentItemDelayFree.getFreeAmount())).toString();
		        //已缴金额
		        String oldAmount = new BigDecimal(paymentItemDelay.getYjje()).add(new BigDecimal(paymentItemDelayFree.getFreeAmount())).toString();
		        //金额扣减
		        paymentItemDelay.setHjye(remainAmount);
		        paymentItemDelay.setYjje(oldAmount);
		        paymentItemDelayService.update(paymentItemDelay);
		        paymentItemDelayFree.setPassDate(new Date());//台账复核批准日期
		        paymentItemDelayFree.setCheckComment(comment);//台账复核意见
		        paymentItemDelayFree.setCurrentAmount(remainAmount);//当前实时余额
		        paymentItemDelayFreeService.update(paymentItemDelayFree);
	            taskService.complete(taskId);
	        }else if(Constant.OUTCOME_FAIL.equals(outcome)){
	        	runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), "人工终止");
	        	paymentItemDelayFreeService.delete(businessKey);
	        }
	        
            this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			logger.error(e.getMessage());
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public PaymentItemDelay getPaymentItemDelay(){
		return this.paymentItemDelay;
	}

	public void setPaymentItemDelay(PaymentItemDelay paymentItemDelay){
		this.paymentItemDelay = paymentItemDelay;
	}
	
	public PaymentItemDelayFree getPaymentItemDelayFree() {
		return paymentItemDelayFree;
	}

	public void setPaymentItemDelayFree(PaymentItemDelayFree paymentItemDelayFree) {
		this.paymentItemDelayFree = paymentItemDelayFree;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getAmount() {
		return amount;
	}

	public void setAmount(String amount) {
		this.amount = amount;
	}
       
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getRegistNo() {
		return registNo;
	}

	public void setRegistNo(String registNo) {
		this.registNo = registNo;
	}
	
	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getOperatorComment() {
		return operatorComment;
	}

	public void setOperatorComment(String operatorComment) {
		this.operatorComment = operatorComment;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}
	
}
