package com.jshx.mobile.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.mobile.dao.MobileDao;
import com.jshx.mobile.service.MobileManager;

@Service("mobileManager")
public class MobileManagerImpl<T, PK extends Serializable> extends
		BaseServiceImpl implements MobileManager<T, PK> {
	/**
	 * Dao类
	 */
	@Resource
	private MobileDao<T, PK> mobileDao;

	public MobileDao<T, PK> getMobileDao() {
		return mobileDao;
	}

	public void setMobileDao(MobileDao<T, PK> mobileDao) {
		this.mobileDao = mobileDao;
	}

	/**
	 * 分页查询
	 * 
	 * @param page
	 *            分页信息
	 * @param paraMap
	 *            查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return mobileDao.findByPage(page, paraMap);
	}

	@Override
	@Transactional
	public Object findClassById(Class class1, String id) {
		// TODO Auto-generated method stub
		return mobileDao.findClassById(class1, id);
	}

	@Override
	@Transactional
	public List<T> findListById(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return mobileDao.findListById(paraMap);
	}

	@Override
	public Object findClassByObject(Class class1, String string, String id) {
		// TODO Auto-generated method stub
		return mobileDao.findClassByObject(class1, string, id);
	}

	@Override
	@Transactional
	public List<T> findListBySqlId(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return mobileDao.findListBySqlId(paraMap);
	}

	@Override
	@Transactional
	public Pagination findBySqlId(Pagination page, Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return mobileDao.findBySqlId(page, paraMap);
	}

	@Override
	@Transactional
	public List<T> findListByObject(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return mobileDao.findListByObject(paraMap);
	}

	@Override
	@Transactional
	public void update(T obj) {
		// TODO Auto-generated method stub
		mobileDao.update(obj);
	}

	@Transactional
	public void saveOrUpdate(T obj) {
		mobileDao.saveOrUpdate(obj);
	}

	@Override
	@Transactional
	public void deleteWithFlag(Class class1, String ids) {
		// TODO Auto-generated method stub
		String[] idArray = ids.split("\\|");

		if (null != idArray) {
			StringBuffer hql = new StringBuffer();
			hql.append("update ");
			hql.append(class1.getName().substring(
					class1.getName().lastIndexOf(".") + 1));
			hql.append(" set delFlag=1 where id in (");
			for (int i = 0; i < idArray.length; i++) {
				hql.append(" '");
				hql.append(idArray[i]);
				hql.append("'");
				if (i < idArray.length - 1)
					hql.append(",");
			}
			hql.append(" )");
			mobileDao.deleteWithFlag(hql.toString());
		}
	}

	@Override
	@Transactional
	public Object getObjectByProperty(Class entity, String[] name,
			Object[] value) {
		// TODO Auto-generated method stub
		return mobileDao.getObjectByProperty(entity, name, value);
	}

	@Override
	@Transactional
	public void updateByHql(String hql) {
		// TODO Auto-generated method stub
		mobileDao.updateByHql(hql);
	}
	
	@Override
	@Transactional
	public void saveOrUpdateByHql(T obj) {
		// TODO Auto-generated method stub
		mobileDao.saveOrUpdateByHql(obj);
	}

	@Override
	@Transactional
	public void saveAllOrUpdateAll(List obj)
	{
		mobileDao.saveOrUpdate(obj);
	}
	@Override
	@Transactional
	public void saveOrUpdate2(List list) {
		// TODO Auto-generated method stub
		mobileDao.saveOrUpdate(list);
	}

	@Override
	@Transactional
	public void deleteBySql(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		mobileDao.deleteBySql(paraMap);
	}

	@Override
	public List findTime(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return mobileDao.findListBySqlId(paraMap);
	}

	@Override
	@Transactional
	public void delete(T t) {
		// TODO Auto-generated method stub
		mobileDao.delete(t);
	}

}
