package com.jshx.mobile.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.jshx.core.base.vo.Pagination;

public interface MobileManager<T, PK extends Serializable> {

	public Pagination findByPage(Pagination pagination, Map<String, Object> paraMap);

	public Object findClassById(Class class1, String id);

	public List<T> findListById(Map<String, Object> paraMap);

	public Object findClassByObject(Class class1, String string, String id);

	public Object getObjectByProperty(Class entity, String[] name, Object[] value);

	/**
	 * 返回map类型的list
	 * 
	 * @param paraMap
	 * @return
	 */
	public List<T> findListBySqlId(Map<String, Object> paraMap);

	public Pagination findBySqlId(Pagination pagination, Map<String, Object> paraMap);

	/**
	 * 返回object类型的list
	 * 
	 * @param paraMap
	 * @return
	 */
	public List<T> findListByObject(Map<String, Object> paraMap);

	public void update(T obj);

	public void delete(T obj);

	public void saveOrUpdate(T obj);

	public void saveOrUpdate2(List<T> list);

	void deleteWithFlag(Class class1, String ids);

	public void updateByHql(String string);

	public void saveOrUpdateByHql(T obj);

	public void deleteBySql(Map<String, Object> paraMap);

	public void saveAllOrUpdateAll(List obj);

	public List findTime(Map<String, Object> paraMap);

}
