package com.jshx.mobile.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.stereotype.Component;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.mobile.dao.MobileDao;

@Component("mobileDao")
public class MobileDaoImpl<T, PK extends Serializable> extends BaseDaoImpl implements MobileDao<T, PK> {
	@Resource
	private SqlMapClient sqlMapClient;

	/**
	 * 分页查询
	 * 
	 * @param page
	 *            分页信息
	 * @param paraMap
	 *            查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId(paraMap.get("HqlId").toString(), paraMap, page);
	}

	@Override
	public Object findClassById(Class class1, String id) {
		// TODO Auto-generated method stub
		return getObjectById(class1, id);
	}

	@Override
	public List<T> findListById(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return this.findListByHqlId(paraMap.get("HqlId").toString(), paraMap);
	}

	@Override
	public Object findClassByObject(Class class1, String name, String id) {
		// TODO Auto-generated method stub
		return getObjectByProperty(class1, name, id);
	}

	@Override
	public List<T> findListBySqlId(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		if (hsql != null) {
			StringBuffer buffHSQL = new StringBuffer(hsql);
			Query query = getSession().createSQLQuery(buffHSQL.toString())
					.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
			setQueryParameters(query, paraMap);
			return query.list();
		}
		return null;
	}

	/*
	 * public String convertToCountSqlStatement(String hsql) { return
	 * "select count(*) from (" + hsql + ") aa"; }
	 */

	@Override
	public Pagination findBySqlId(Pagination pagination, Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		String countSql = convertToCountSqlStatement(hsql);
		try {
			int count = 0;
			if (countSql != null) {
				Query countQuery = getSession().createSQLQuery(countSql);
				setQueryParameters(countQuery, paraMap);

				count = Integer.parseInt(countQuery.uniqueResult().toString());

				pagination.setTotalCount(count);
			}
			if ((hsql != null) && (count != 0)) {
				StringBuffer buffHSQL = new StringBuffer(hsql);

				Query query = getSession().createSQLQuery(buffHSQL.toString())
						.setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
				setQueryParameters(query, paraMap);
				query.setFirstResult(pagination.getFirstResult());
				query.setMaxResults(pagination.getPageSize());

				List restList = query.list();

				pagination.setList(restList);
			} else {
				if (hsql == null)
					throw new BasalException(BasalException.ERROR,
							"未在 SqlMap配置文件中配置, ID为" + paraMap.get("SqlId").toString() + "的hql 语句");
				if (count == 0)
					pagination.setList(new ArrayList());
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new BasalException(BasalException.ERROR, e.getCause().getMessage());
		}

		return pagination;
	}

	@Override
	public List<T> findListByObject(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		if (hsql != null) {
			StringBuffer buffHSQL = new StringBuffer(hsql);
			Query query = getSession().createSQLQuery(buffHSQL.toString());
			setQueryParameters(query, paraMap);
			return query.list();
		}
		return null;
	}

	@Override
	public void update(T obj) {
		// TODO Auto-generated method stub
		getSession().update(obj);
	}

	public void saveOrUpdate(T entity) {
		getSession().merge(entity);
		getSession().flush();
	}

	@Override
	public void deleteWithFlag(String hql) {
		// TODO Auto-generated method stub
		getSession().createQuery(hql).executeUpdate();
	}

	@Override
	public String getNextVal() {
		// TODO Auto-generated method stub
		String sql = "select nextval('petitionEtterNO')";
		Query query = getSession().createSQLQuery(sql);
		List list = query.list();
		if (null != list && list.size() > 0)
			return (String) list.get(0);
		return null;
	}

	@Override
	public Object getObjectByProperty(Class entity, String[] name, Object[] value) {
		Criteria criteria = getSession().createCriteria(entity);
		for (int i = 0; i < name.length; i++)
			criteria.add(Restrictions.eq(name[i], value[i]));
		criteria.setMaxResults(1);
		return criteria.uniqueResult();
	}

	@Override
	public void updateByHql(String hql) {
		// TODO Auto-generated method stub
		getSession().createQuery(hql).executeUpdate();
	}

	@Override
	public void saveOrUpdateByHql(T entity) {
		// TODO Auto-generated method stub
		getSession().saveOrUpdate(entity);
	}

	@Override
	public void saveOrUpdate(List list) {
		// TODO Auto-generated method stub
		for (int i = 0; i < list.size(); i++) {
			getSession().saveOrUpdate(list.get(i));
		}
	}

	@Override
	public void deleteBySql(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		String hsql = this.getSqlStatementById(paraMap.get("SqlId").toString(), paraMap);
		if (hsql != null) {
			StringBuffer buffHSQL = new StringBuffer(hsql);
			Query query = getSession().createSQLQuery(buffHSQL.toString());
			setQueryParameters(query, paraMap);
			query.executeUpdate();

		}
	}

	@Override
	public void delete(T t) {
		// TODO Auto-generated method stub
		getSession().delete(t);
	}
}
