package com.jshx.message.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.message.dao.JshxMessageInfoDao;
import com.jshx.message.entity.JshxMessageInfo;

@Service("jshxMessageInfoService")
public class JshxMessageInfoService extends BaseServiceImpl
{
	/**
	 * Dao类
	 */
	@Resource
	private JshxMessageInfoDao dao;
	
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return dao.findByPage(page, paraMap);
	}

	/**
	 * 群发短信分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPageSms(Pagination page, Map<String, Object> paraMap){
		return dao.findByPageSms(page, paraMap);
	}
	
	/**
	 * 分页查询首页
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findByPageOfOne(Map<String, Object> paraMap)
	{
		return dao.findByPageOfOne(paraMap);
	}
	
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public JshxMessageInfo getById(String id)
	{
		return dao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(JshxMessageInfo model)
	{
		dao.save(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(JshxMessageInfo model)
	{
		dao.update(model);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		if(null != ids)
		{
			for(String id : ids)
			{
				dao.delete(id);
			}
		}
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String[] ids)
	{
		if(null != ids)
		{
			for(String id : ids)
			{
				dao.deleteWithFlag(id);
			}
		}
	}
	
	/**
	 * <查询短信消息信息表>
	 * @param paraMap
	 * @return
	 *
	 * 创建时间：2011-3-1
	 * 创建人：duanpf
	 * 方法描述：
	 * （参数含义说明如下）
	 */
	public List findListByMap( Map<String, Object> paraMap){
		return dao.findListByMap(paraMap);
	}
	
}
