package com.jshx.message.dao;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.message.entity.JshxMessageInfo;

@Component("jshxMessageInfoDao")
public class JshxMessageInfoDao extends BaseDaoImpl
{
	/**
	 * 公司公告分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJshxMessageInfoByPage", paraMap, page);
	}
	
	/**
	 * 群发短信分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPageSms(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJshxMessageInfoByPageSms", paraMap, page);
	}
	
	/**
	 * 分页查询首页
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findByPageOfOne(Map<String, Object> paraMap)
	{
		return this.findListByHqlId("findJshxMessageInfoByPageOfOne", paraMap);
	
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public JshxMessageInfo getById(String id)
	{
		return (JshxMessageInfo)this.getObjectById(JshxMessageInfo.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(JshxMessageInfo model)
	{
		model.setId(null);
		//此处处理Blob对象（Blob对象不能直接insert）
		this.saveOrUpdateObject(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(JshxMessageInfo model)
	{
		this.saveOrUpdateObject(model);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(JshxMessageInfo.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		JshxMessageInfo model = (JshxMessageInfo)this.getObjectById(JshxMessageInfo.class, id);
		model.setDelFlag(1);
		this.saveObject(model);
	}
	
	/**
	 * <查询公司公告信息表>
	 * @param paraMap
	 * @return
	 *
	 * 创建时间：2011-3-1
	 * 创建人：duanpf
	 * 方法描述：
	 * （参数含义说明如下）
	 */
	public List findListByMap( Map<String, Object> paraMap){
		return this.findListByHqlId("findJshxMessageInfoByPage", paraMap);
	}	
}
