package com.jshx.makereport.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.makereport.entity.Makereport;
import com.jshx.makereport.dao.MakereportDao;

@Component("makereportDao")
public class MakereportDaoImpl extends BaseDaoImpl implements MakereportDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findMakereportByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findMakereport(Map<String, Object> paraMap){
		return this.findListByHqlId("findMakereportByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Makereport getById(String id)
	{
		return (Makereport)this.getObjectById(Makereport.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Makereport makereport)
	{
		makereport.setId(null);
		this.saveOrUpdateObject(makereport);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Makereport makereport)
	{
		this.saveOrUpdateObject(makereport);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Makereport.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Makereport makereport = (Makereport)this.getObjectById(Makereport.class, id);
		makereport.setDelFlag(1);
		this.saveObject(makereport);
	}
}
