package com.jshx.kpsjgl.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.kpsjgl.dao.KpsjglDao;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.service.KpsjglService;

@Service("kpsjglService")
public class KpsjglServiceImpl extends BaseServiceImpl implements KpsjglService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("kpsjglDao")
	private KpsjglDao kpsjglDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return kpsjglDao.findByPage(page, paraMap);
	}
        
	
	
	
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	@Transactional
	public Kpsjgl getById(String id)
	{
		return kpsjglDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Kpsjgl kpsjgl)
	{
		kpsjglDao.save(kpsjgl);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Kpsjgl kpsjgl)
	{
		kpsjglDao.update(kpsjgl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=kpsjglDao.findKpsjgl(paraMap);
		
		kpsjglDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    kpsjglDao.deleteWithFlag(id);
			}
		}
	}




	@Transactional
    public List<Kpsjgl> findlkall(Map<String, Object> paraMap) {
        // TODO Auto-generated method stub
        return kpsjglDao.findKpsjgl(paraMap);
    }




    @Override
    public Kpsjgl findbygllb(String gllb) {
        // TODO Auto-generated method stub

        Map<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("gllb", gllb);
        List<Kpsjgl> os=kpsjglDao.findKpsjgl(paraMap);
        if(null!=os&&os.size()>0){
            return os.get(0);
        }else{
            return null;
        }
    }
}
