package com.jshx.kpsjgl.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.dao.KpsjglDao;

@Component("kpsjglDao")
public class KpsjglDaoImpl extends BaseDaoImpl implements KpsjglDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findKpsjglByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findKpsjgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findKpsjglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Kpsjgl getById(String id)
	{
		return (Kpsjgl)this.getObjectById(Kpsjgl.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Kpsjgl kpsjgl)
	{
		kpsjgl.setId(null);
		this.saveOrUpdateObject(kpsjgl);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Kpsjgl kpsjgl)
	{
		this.saveOrUpdateObject(kpsjgl);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Kpsjgl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Kpsjgl kpsjgl = (Kpsjgl)this.getObjectById(Kpsjgl.class, id);
		kpsjgl.setDelFlag(1);
		this.saveObject(kpsjgl);
	}
}
