package com.jshx.kjkmb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.kjkmb.dao.KjkmbDao;
import com.jshx.kjkmb.entity.Kjkmb;
import com.jshx.kjkmb.service.KjkmbService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

@Service("kjkmbService")
public class KjkmbServiceImpl extends BaseServiceImpl implements KjkmbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("kjkmbDao")
	private KjkmbDao kjkmbDao;
	
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	@Autowired
	private TfspbService tfspbService;
	@Autowired
	private ZsdwService zsdwService;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return kjkmbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Kjkmb getById(String id)
	{
		return kjkmbDao.getById(id);
	}
    
	
	
	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Kjkmb kjkmb)
	{
		kjkmbDao.save(kjkmb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Kjkmb kjkmb)
	{
		kjkmbDao.update(kjkmb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=kjkmbDao.findKjkmb(paraMap);
		
		kjkmbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    kjkmbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Kjkmb getByslbh(String slbh,String kmlx) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", slbh);
	   List<Xmxxb> lisxm=	xmxxbService.findXmxxb(paraMap);
	   if(lisxm.size()>0){
		   Xmxxb bean= lisxm.get(0);
		   Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("dwdm", bean.getDwdm());
			paraMap1.put("kmlx", kmlx);
			if("sf".equals(bean.getDwdm())){
				if("南京南站".equals(bean.getZsfw().trim())){
                    if("2102".equals(kmlx)){
                    	paraMap1.put("kjkm","21020103");
                    	}					
                    if("1030156".equals(kmlx)){
                    	paraMap1.put("kjkm","1031560103");
                    }					
                    
				}else if("燕子矶新城".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020102");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560102");
	                    }
				}else if("河西区域".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020104");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560104");
	                    }
				}else if("仙林区域".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020105");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560105");
	                    }
				}else if("麒麟区域".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020106");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560106");
	                    }
				}else if("南部区域".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020107");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560107");
	                    }
				}else if("软件谷区域".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020108");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560108");
	                    }
				}else if("新尧新城".equals(bean.getZsfw().trim())){
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020109");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560109");
	                    }
				}else {
					   if("2102".equals(kmlx)){
	                    	paraMap1.put("kjkm","21020101");
	                    	}					
	                    if("1030156".equals(kmlx)){
	                    	paraMap1.put("kjkm","1031560101");
	                    }
		   }
		
	}
		   List<Kjkmb>	lks=kjkmbDao.findKjkmb(paraMap1);
		   if(lks.size()>0){
			   return lks.get(0);
		   }
			
}else{
	PaymentItemDelay	pa=paymentItemDelayService.getBySlbh(slbh);
	   Map<String, Object> paraMap1 = new HashMap<String, Object>();
		paraMap1.put("dwdm", pa.getDwdm());
		paraMap1.put("kmlx", kmlx);
		if("sf".equals(pa.getDwdm())){
				   if("2102".equals(kmlx)){
                    	paraMap1.put("kjkm","21020101");
                    	}					
                    if("1030156".equals(kmlx)){
                    	paraMap1.put("kjkm","1031560101");
                    }
}
	   List<Kjkmb>	lks=kjkmbDao.findKjkmb(paraMap1);
	   if(lks.size()>0){
		   return lks.get(0);
	   }
}
	return null;
}
	@Override
	public Kjkmb getByslbhtf(String slbh,String kmlx) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", slbh);
		List<Xmxxb> lisxm=	xmxxbService.findXmxxb(paraMap);
		if(lisxm.size()>0){
			Xmxxb bean= lisxm.get(0);
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("dwdm", bean.getDwdm());
			paraMap1.put("kmlx", kmlx);
			if("sf".equals(bean.getDwdm())){
				if("南京南站".equals(bean.getZsfw().trim())){
					if("2102".equals(kmlx)){
						paraMap1.put("kjkm","21020103");
					}					
					if("1030156".equals(kmlx)){
						paraMap1.put("kjkm","1031560103");
					}					
					
				}else if("燕子矶新城".equals(bean.getZsfw().trim())){
					if("2102".equals(kmlx)){
						paraMap1.put("kjkm","21020102");
					}					
					if("1030156".equals(kmlx)){
						paraMap1.put("kjkm","1031560102");
					}
				}else{
					if("2102".equals(kmlx)){
						paraMap1.put("kjkm","21020101");
					}					
					if("1030156".equals(kmlx)){
						paraMap1.put("kjkm","1031560101");
					}
				}
				
			}
			List<Kjkmb>	lks=kjkmbDao.findKjkmb(paraMap1);
			if(lks.size()>0){
				return lks.get(0);
			}
			
		}else{
//			PaymentItemDelay	pa=paymentItemDelayService.getBySlbh(slbh);
			Tfspb tfspb = tfspbService.getBYslbh(slbh);
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			String zsdm=zsdwService.getDwdmByzsdw(tfspb.getZsdw());
			paraMap1.put("dwdm",zsdm);
			paraMap1.put("kmlx", kmlx);
			if("sf".equals(zsdm)){
				if("2102".equals(kmlx)){
					paraMap1.put("kjkm","21020101");
				}					
				if("1030156".equals(kmlx)){
					paraMap1.put("kjkm","1031560101");
				}
			}
			List<Kjkmb>	lks=kjkmbDao.findKjkmb(paraMap1);
			if(lks.size()>0){
				return lks.get(0);
			}
		}
		return null;
	}

	@Override
	public List<Kjkmb> kjkmblist(Map<String, Object> paraMap) {
   		return kjkmbDao.findKjkmb(paraMap);
	}

	@Override
	public Kjkmb getBykmlx(String kmlx) {
		String kx="";
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("kjkm",kmlx);
		List<Kjkmb>	lks=kjkmbDao.findKjkmb(paraMap);
		   if(lks.size()>0){
			   return lks.get(0);
		   }
		return null;
	}
}
	

