package com.jshx.jtqd.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.dao.JtqdDao;

@Component("jtqdDao")
public class JtqdDaoImpl extends BaseDaoImpl implements JtqdDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJtqdByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJtqd(Map<String, Object> paraMap){
		return this.findListByHqlId("findJtqdByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jtqd getById(String id)
	{
		return (Jtqd)this.getObjectById(Jtqd.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jtqd jtqd)
	{
		jtqd.setId(null);
		this.saveOrUpdateObject(jtqd);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jtqd jtqd)
	{
		this.saveOrUpdateObject(jtqd);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jtqd.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jtqd jtqd = (Jtqd)this.getObjectById(Jtqd.class, id);
		jtqd.setDelFlag(1);
		this.saveObject(jtqd);
	}

	@Override
	public Pagination findByPage1(Pagination page, Map<String, Object> paraMap) {
		return this.findPageByHqlId("findJtqdByMap1", paraMap, page);
	}
}
