package com.jshx.jmmx.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jmmx.dao.JmmxDao;
import com.jshx.jmmx.entity.Jmmx;
import com.jshx.jmmx.service.JmmxService;

@Service("jmmxService")
public class JmmxServiceImpl extends BaseServiceImpl implements JmmxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jmmxDao")
	private JmmxDao jmmxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jmmxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jmmx getById(String id)
	{
		return jmmxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Jmmx jmmx)
	{
		jmmxDao.save(jmmx);
	}
	
     /**
      * 批量保存
     * @throws Exception 
      */
	@Transactional
   public String savelist(List<Jmmx> list) throws Exception {
		String message="0";
        try{
        	for (Jmmx jmmx : list) {
    			jmmxDao.save(jmmx);
    		}	
        }catch(Exception ex){
        	message="1";
        	TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        	
        }
        return message;
    }
	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Jmmx jmmx)
	{
		jmmxDao.update(jmmx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jmmxDao.findJmmx(paraMap);
		
		jmmxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jmmxDao.deleteWithFlag(id);
			}
		}
	}
}
