package com.jshx.jktzs.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import com.fr.function.CNMONEY;
import com.jshx.common.utils.NumberToCN;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.service.ELicenseService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.service.LxrinfoService;
import com.jshx.mjyj.entity.Mjyj;
import com.jshx.mjyj.service.MjyjService;

public class JktzsAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private String paymentLinkStatus;

	/**
	 * 实体类
	 */
	private Jktzs jktzs = new Jktzs();
	
	private Mjyj mjyj = new Mjyj();

	private Zsdw zsdwxx = new Zsdw();
	private Lxrinfo lxrinfo=new Lxrinfo();

	//2019-6-21
	private Xmxxb xmxxb;

	// 2021-3-5
	private ELicense eLicense;
	/**
	 * 业务类
	 */
	//2019-6-21 xmxxb
	@Autowired
	private XmxxbService xmxxbService;

	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private CktzsService cktzsService;
	@Autowired
	private MjyjService mjyjService;
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	@Autowired
	private LxrinfoService lxrinfoService;
	@Autowired
	private ELicenseService eLicenseService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 大写金额
	 */
	private String cnAmount;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	private String orderId ;
	private String jdtzsbz;

	//政策类别
	private String zclb;
	
	public String getJdtzsbz() {
		return jdtzsbz;
	}

	public void setJdtzsbz(String jdtzsbz) {
		this.jdtzsbz = jdtzsbz;
	}

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != jktzs){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != jktzs.getSlbh()) && (0 < jktzs.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + jktzs.getSlbh().trim() + "%");
			}

			if ((null != jktzs.getXxbbh()) && (0 < jktzs.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + jktzs.getXxbbh().trim() + "%");
			}

			if ((null != jktzs.getDwmc()) && (0 < jktzs.getDwmc().trim().length())){
				paraMap.put("dwmc", "%" + jktzs.getDwmc().trim() + "%");
			}
			if ((null != jktzs.getDzbh()) && (0 < jktzs.getDzbh().trim().length())){
				paraMap.put("dzbh", "%" + jktzs.getDzbh().trim() + "%");
			}

			if ((null != jktzs.getXmmc()) && (0 < jktzs.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + jktzs.getXmmc().trim() + "%");
			}

			if ((null != jktzs.getXmdd()) && (0 < jktzs.getXmdd().trim().length())){
				paraMap.put("xmdd", "%" + jktzs.getXmdd().trim() + "%");
			}

			if ((null != jktzs.getCkbh()) && (0 < jktzs.getCkbh().trim().length())){
				paraMap.put("ckbh", "%" + jktzs.getCkbh().trim() + "%");
			}

			if ((null != jktzs.getDwdm()) && (0 < jktzs.getDwdm().trim().length())){
				paraMap.put("dwdm", "%" + jktzs.getDwdm().trim() + "%");
			}

			if ((null != jktzs.getGhxkz()) && (0 < jktzs.getGhxkz().trim().length())){
				paraMap.put("ghxkz", "%" + jktzs.getGhxkz().trim() + "%");
			}

			if ((null != jktzs.getLianxiren()) && (0 < jktzs.getLianxiren().trim().length())){
				paraMap.put("lianxiren", "%" + jktzs.getLianxiren().trim() + "%");
			}

			if ((null != jktzs.getDkslh()) && (0 < jktzs.getDkslh().trim().length())){
				paraMap.put("dkslh", "%" + jktzs.getDkslh().trim() + "%");
			}

			if ((null != jktzs.getIsqtfy()) && (0 < jktzs.getIsqtfy().trim().length())){
				paraMap.put("isqtfy", "%" + jktzs.getIsqtfy().trim() + "%");
			}
			if ((null != jktzs.getDyriqi())){
				paraMap.put("dyrq", "1");
			}
			if (StringUtils.isNotBlank(zclb)){
				paraMap.put("zclb", (Integer.parseInt(zclb.trim())-1) + "");
			}
			if (StringUtils.isNotBlank(jktzs.getElFlag()) && (0 < jktzs.getElFlag().trim().length())){
				paraMap.put("elFlag", jktzs.getElFlag());
			}
			/*if (StringUtils.isNotBlank(jktzs.getElicenseId()) && (0 < jktzs.getElicenseId().trim().length())){
				paraMap.put("elicenseId", jktzs.getElicenseId().trim() + "%");
			}*/

		}
		
         
         String dwdm="";
         if(!this.getLoginUser().getIsSuperAdmin()){
           dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
         }
         if(!"".equals(dwdm)){
        	paraMap.put("dwdm", dwdm);
         }
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|createTime|xmdd|mjmj|mjje|lianxiren|phone|xqtyj|byyj|xxbbh|rfyj|dkslh|dkmj|dycs|slbh|xmmc|ckbh|ghxkz|zjzmj|csptf|jfmj|jfje|dzbh|dwmc|dyriqi|tsjl|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = jktzsService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
         public void dycs(){
             String cjinfo="";
             if(null!=jdtzsbz&&!"".equals(jdtzsbz)){
                 //有催款未交等
                 cjinfo="您单位 "+jdtzsbz+" 逾期未缴纳配套费,请在领取本项目配套费缴费凭证前,按照催缴通知书要求缴清未交款项";
             }
             String qtfyinfo="";
             if("1".equals(jktzs.getIsqtfy())){
                 qtfyinfo="人防易地费应缴 "+SysPropertiesUtil.qwfgf(jktzs.getRfyj()) +" 元";
             }
             String bzinfo="";
             if(null!=jktzs.getDkslh()&&!"".equals(jktzs.getDkslh())){
                 bzinfo="抵扣面积:"+jktzs.getDkmj()+" 受理编号:"+jktzs.getDkslh();
             }
             this.setRequestAttribute("cjasd", cjinfo);
             this.setRequestAttribute("qtfyinfo", qtfyinfo);
             this.setRequestAttribute("asd", bzinfo);
             
         }
         public String dycs1(){
             StringBuffer sb=new StringBuffer("");
             String cjinfo="";
             if(null!=jdtzsbz&&!"".equals(jdtzsbz)){
                 //有催款未交等
                 cjinfo="您单位 "+jdtzsbz+" 逾期未缴纳配套费,请在领取本项目配套费缴费凭证前,按照催缴通知书要求缴清未交款项";
                 sb.append(cjinfo);
             }
             String qtfyinfo="";
             if("1".equals(jktzs.getIsqtfy())){
                 qtfyinfo="人防易地费应缴 "+SysPropertiesUtil.qwfgf(jktzs.getRfyj()) +" 元";
                 sb.append(qtfyinfo);
             }
             String bzinfo="";
             if(null!=jktzs.getDkslh()&&!"".equals(jktzs.getDkslh())){
                 bzinfo="抵扣面积:"+jktzs.getDkmj()+" 受理编号:"+jktzs.getDkslh();
                 sb.append(bzinfo);
             }
             this.setRequestAttribute("cjasd", cjinfo);
             this.setRequestAttribute("qtfyinfo", qtfyinfo);
             this.setRequestAttribute("asd", bzinfo);
             return sb.toString();
         }
	/**
	 * 打印
	 */
	public String view1() throws Exception{
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		this.setRequestAttribute("currentDate", outSdf.format(new Date()));
		String ydy="0";
		if((null != jktzs)&&(null != jktzs.getId())){
			jktzs = jktzsService.getById(jktzs.getId());
			//查询是否有催缴款
			iscuijiao(jktzs);
			//打印页面参数设置(只记录第一次的情况)
			String jilu=dycs1();
			if(null==jktzs.getDyriqi()||"".equals(jktzs.getDyriqi())){
			    jktzs.setTsjl(jilu);
			}
			//记录打印时间,30天超时,缴款通知书和代缴款表 都加入
			if(null==jktzs.getDyriqi()||"".equals(jktzs.getDyriqi())){
				ydy="1";
				jktzs.setDyriqi(new Date());
				jktzsService.update(jktzs);
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("slbh", jktzs.getSlbh());
				List<PaymentItemPending> lps=null;
				lps=paymentItemPendingService.findPaymentItemPending(paraMap);
			    if(null!=lps&&lps.size()>0){
			    	PaymentItemPending p=lps.get(0);
			    	p.setDyriqi(new Date());
			    	paymentItemPendingService.update(p);
			    }
			}
			xmxxb = xmxxbService.getById(jktzs.getXmbzj());
			paymentLinkStatus = xmxxb.getPaymentLink()==null?null:xmxxb.getPaymentLink()+"";
		}
		this.setRequestAttribute("ydy", ydy);
		zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
		lxrinfo=lxrinfoService.getBybhdwdm("001", zsdwxx.getZsdm());

		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("jktzsId", jktzs.getId());
		List<ELicense> eLicenseList = eLicenseService.findELicenseList(paraMap);
		eLicense = eLicenseList.size()>0?eLicenseList.get(0):new ELicense();
		return VIEW;
	}
	public String view() throws Exception{
		if((null != jktzs)&&(null != jktzs.getId())){
			jktzs = jktzsService.getById(jktzs.getId());
			//查询是否有催缴款
			iscuijiao(jktzs);
			//打印页面参数设置
                        dycs();
			
		}
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		this.setRequestAttribute("currentDate", outSdf.format(new Date()));
		zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
		      lxrinfo=lxrinfoService.getBybhdwdm("001", zsdwxx.getZsdm());
		// 2019-6-21 添加中文大写金额 start
		cnAmount = NumberToCN.number2CNMontrayUnit(new BigDecimal(jktzs.getJfje()));
		xmxxb = xmxxbService.getById(jktzs.getXmbzj());
		//2021-3-5
		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("jktzsId", jktzs.getId());
		List<ELicense> eLicenseList = eLicenseService.findELicenseList(paraMap);
		eLicense = eLicenseList.size()>0?eLicenseList.get(0):new ELicense();
		paymentLinkStatus = xmxxb.getPaymentLink()==null?null:xmxxb.getPaymentLink()+"";
		//2019-6-21 end
		if(jktzs.getDwdm().equals("jk")||jktzs.getDwdm().equals("jb")){
			return "viewjk";
		}
		return VIEW;
	}
	public String viewjfsl() throws Exception{
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		this.setRequestAttribute("currentDate", outSdf.format(new Date()));
		if((null != jktzs)&&(null != jktzs.getId())){
			Map<String, Object> paraMap = new HashMap<String, Object>();
             paraMap.put("xmbzj", jktzs.getId());
             List<Jktzs> ljs= jktzsService.findByAll(paraMap);
			jktzs = ljs.get(0);
			//查询是否有催缴款
			iscuijiao(jktzs);
			//打印页面参数设置
                        dycs();
			
		}
		zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
		      lxrinfo=lxrinfoService.getBybhdwdm("001", zsdwxx.getZsdm());

		Map<String, Object> paraMap = new HashMap<>();
		paraMap.put("jktzsId", jktzs.getId());
		List<ELicense> eLicenseList = eLicenseService.findELicenseList(paraMap);
		eLicense = eLicenseList.size()>0?eLicenseList.get(0):new ELicense();
		return VIEW;
	}
	

	private void iscuijiao(Jktzs jktzs) {
//		Map<String, Object> paraMap = new HashMap<String, Object>();
//		if(!"".equals(jktzs.getDwmc().trim())){
//		  paraMap.put("dwmc","%"+ jktzs.getDwmc()+"%");
//		  List<Cktzs> cklist=cktzsService.findByall(paraMap);
//		  if(cklist.size()>0){
//			  orderId = cklist.get(0).getSlbh();
//		  }
//		}
//		
		
		String ckhj="0";
		orderId ="";
		if(null!=jktzs.getDkslh()&&!"".equals(jktzs.getDkslh())){
			
			ckhj="1";
			orderId="抵扣面积:"+jktzs.getDkmj()+"编号:"+jktzs.getDkslh()+".";
		}
		
		if(null!=jktzs.getDwmc()&&!"".equals(jktzs.getDwmc().trim())){
		Map<String, Object> sjk = new HashMap<String, Object>();
		sjk.put("dwmc", jktzs.getDwmc().trim());
          List<PaymentItemDelay> pas=paymentItemDelayService.findall(sjk);
		sjk.put("isjk", "0");
		List<Cktzs> cks=cktzsService.findByall(sjk);
		    if(pas.size()>0){
		    	//缓缴项目
		    	for (PaymentItemDelay pbean : pas) {
					if(!"0".equals(pbean.getHjye())){
						ckhj="1";
						orderId+="存在缓缴:"+pbean.getSlbh()+".";	
						jdtzsbz=pbean.getXmmc()+" "+pbean.getSlbh();
					}
				}
		    }
		    if(cks.size()>0){
		    	//超时项目
		    	ckhj="1";
		    	for (Cktzs cbean : cks) {
		    		orderId+=" 超时未缴:"+cbean.getSlbh()+".";
		    		jdtzsbz=cbean.getXmmc()+" "+cbean.getSlbh();
				}
		    	
		    }
		    
		    
		}
		
		
		
		
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			jktzs.setDeptId(this.getLoginUserDepartmentId());
			jktzs.setDelFlag(0);
			jktzs.setElFlag("0");
			jktzsService.save(jktzs);
		}else{
			jktzsService.update(jktzs);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != jktzs)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到jktzs中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			jktzsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public static void main(String[] args) {
		String cnMoney = NumberToCN.number2CNMontrayUnit(new BigDecimal("3453345354"));

		System.out.println(cnMoney);
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Jktzs getJktzs(){
		return this.jktzs;
	}

	public void setJktzs(Jktzs jktzs){
		this.jktzs = jktzs;
	}
	
	public Mjyj getMjyj() {
		return mjyj;
	}

	public void setMjyj(Mjyj mjyj) {
		this.mjyj = mjyj;
	}

	public Zsdw getZsdwxx() {
		return zsdwxx;
	}

	public void setZsdwxx(Zsdw zsdwxx) {
		this.zsdwxx = zsdwxx;
	}
        
	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

    public Lxrinfo getLxrinfo() {
        return lxrinfo;
    }

    public void setLxrinfo(Lxrinfo lxrinfo) {
        this.lxrinfo = lxrinfo;
    }

	public String getCnAmount() {
		return cnAmount;
	}

	public void setCnAmount(String cnAmount) {
		this.cnAmount = cnAmount;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public String getZclb() {
		return zclb;
	}

	public void setZclb(String zclb) {
		this.zclb = zclb;
	}

	public ELicense geteLicense() {
		return eLicense;
	}

	public void seteLicense(ELicense eLicense) {
		this.eLicense = eLicense;
	}

	public String getPaymentLinkStatus() {
		return paymentLinkStatus;
	}

	public void setPaymentLinkStatus(String paymentLinkStatus) {
		this.paymentLinkStatus = paymentLinkStatus;
	}
}
