package com.jshx.jktzs.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jktzs.dao.JktzsDao;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;

@Service("jktzsService")
public class JktzsServiceImpl extends BaseServiceImpl implements JktzsService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jktzsDao")
	private JktzsDao jktzsDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jktzsDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jktzs getById(String id)
	{
		return jktzsDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Jktzs jktzs)
	{
		jktzsDao.save(jktzs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Jktzs jktzs)
	{
		jktzsDao.update(jktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jktzsDao.findJktzs(paraMap);
		
		jktzsDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jktzsDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public List<Jktzs> findByAll(Map<String, Object> paraMap) {
		return jktzsDao.findJktzs(paraMap);
		 
	}
}
