package com.jshx.jktzs.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.dao.JktzsDao;

@Component("jktzsDao")
public class JktzsDaoImpl extends BaseDaoImpl implements JktzsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJktzsByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJktzs(Map<String, Object> paraMap){
		return this.findListByHqlId("findJktzsByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jktzs getById(String id)
	{
		return (Jktzs)this.getObjectById(Jktzs.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jktzs jktzs)
	{
		jktzs.setId(null);
		this.saveOrUpdateObject(jktzs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jktzs jktzs)
	{
		this.saveOrUpdateObject(jktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jktzs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jktzs jktzs = (Jktzs)this.getObjectById(Jktzs.class, id);
		jktzs.setDelFlag(1);
		this.saveObject(jktzs);
	}
}
