package com.jshx.jkmx.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jmmx.entity.Jmmx;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.xmxxb.entity.Xmxxb;

public interface JkmxService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);
	public List<Jkmx> findall(Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jkmx getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jkmx model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jkmx model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	
	public String savelist(List<Jkmx> list)throws Exception;
	/**
	 * 操作 回滚用
	 */
	public String caozuo(List<Jkmx> li,Spjkjl spjkjl ,List<Qtfymx> qtxmlist,Xmxxb xmbbean,String dikoumj,String yjmj,String message )throws Exception;
}
