package com.jshx.jkmx.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.dao.JkmxDao;

@Component("jkmxDao")
public class JkmxDaoImpl extends BaseDaoImpl implements JkmxDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findJkmxByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findJkmx(Map<String, Object> paraMap){
		return this.findListByHqlId("findJkmxByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jkmx getById(String id)
	{
		return (Jkmx)this.getObjectById(Jkmx.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Jkmx jkmx)
	{
		jkmx.setId(null);
		this.saveOrUpdateObject(jkmx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Jkmx jkmx)
	{
		this.saveOrUpdateObject(jkmx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Jkmx.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Jkmx jkmx = (Jkmx)this.getObjectById(Jkmx.class, id);
		jkmx.setDelFlag(1);
		this.saveObject(jkmx);
	}
}
