package com.jshx.jizihao.service.impl;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.apache.fop.cli.Main;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jizihao.dao.JizihaoDao;
import com.jshx.jizihao.entity.Jizihao;
import com.jshx.jizihao.service.JizihaoService;

@Service("jizihaoService")
public class JizihaoServiceImpl extends BaseServiceImpl implements JizihaoService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jizihaoDao")
	private JizihaoDao jizihaoDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jizihaoDao.findByPage(page, paraMap);
	}
	

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jizihao getById(String id)
	{
		return jizihaoDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Jizihao jizihao)
	{
		jizihaoDao.save(jizihao);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Jizihao jizihao)
	{
		jizihaoDao.update(jizihao);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jizihaoDao.findJizihao(paraMap);
		
		jizihaoDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jizihaoDao.deleteWithFlag(id);
			}
		}
	}


	@Override
	public List<Jizihao> findall(Map<String, Object> paraMap) {
		return jizihaoDao.findJizihao(paraMap);
	}

	@Transactional
	public String zijibynianyue(String nianyue) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		 paraMap.put("nianyue", nianyue);
		List<Jizihao> jis= jizihaoDao.findJizihao(paraMap);
		if(jis.size()>0){
			Jizihao bean=jis.get(0);
			String dqjz=bean.getJizihao();
			String xjz=SysPropertiesUtil.add(dqjz, "1");
			double x=Double.valueOf(xjz);
			DecimalFormat df = new DecimalFormat("0000");
			String xin=String.valueOf(df.format(x));
			bean.setJizihao(xin);
			jizihaoDao.update(bean);
			return xin;
		}else{
			Jizihao bean=new Jizihao();
			bean.setDelFlag(0);
			bean.setNianyue(nianyue);
			bean.setJizihao("0001");
			jizihaoDao.save(bean);
			return "0001";
		}
		
	}
	@Transactional
	public String zijibynianyuezck(String nianyue) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("nianyue", nianyue);
		List<Jizihao> jis= jizihaoDao.findJizihao(paraMap);
		if(jis.size()>0){
			Jizihao bean=jis.get(0);
			String dqjz=bean.getJizihao();
			String xjz=SysPropertiesUtil.add(dqjz, "1");
			double x=Double.valueOf(xjz);
			DecimalFormat df = new DecimalFormat("0000");
			String xin=String.valueOf(df.format(x));
//			bean.setJizihao(xin);
//			jizihaoDao.update(bean);
			return xin;
		}else{
			Jizihao bean=new Jizihao();
			bean.setDelFlag(0);
			bean.setNianyue(nianyue);
			bean.setJizihao("0000");
			jizihaoDao.save(bean);
			return "0001";
		}
		
	}


	@Transactional
	public String zijiby(String zsdw) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
	
		 paraMap.put("nianyue", zsdw);
		List<Jizihao> jis= jizihaoDao.findJizihao(paraMap);
		if(jis.size()>0){
			Jizihao bean=jis.get(0);
			String dqjz=bean.getJizihao();
			String xjz=SysPropertiesUtil.add(dqjz, "1");
			double x=Double.valueOf(xjz);
			DecimalFormat df = new DecimalFormat("0000");
			String xin=String.valueOf(df.format(x));
			bean.setJizihao(xin);
			jizihaoDao.update(bean);
			return xin;
		}else{
			Jizihao bean=new Jizihao();
			bean.setDelFlag(0);
			bean.setNianyue(zsdw);
			bean.setJizihao("0001");
			jizihaoDao.save(bean);
			return "0001";
		}
	}
	@Transactional
	public String zijibyck(String zsdw) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		
		paraMap.put("nianyue", zsdw);
		List<Jizihao> jis= jizihaoDao.findJizihao(paraMap);
		if(jis.size()>0){
			Jizihao bean=jis.get(0);
			String dqjz=bean.getJizihao();
			String xjz=SysPropertiesUtil.add(dqjz, "1");
			double x=Double.valueOf(xjz);
			DecimalFormat df = new DecimalFormat("0000");
			String xin=String.valueOf(df.format(x));
//			bean.setJizihao(xin);
//			jizihaoDao.update(bean);
			return xin;
		}else{
//			Jizihao bean=new Jizihao();
//			bean.setDelFlag(0);
//			bean.setNianyue(zsdw);
//			bean.setJizihao("0001");
//			jizihaoDao.save(bean);
			return "0001";
		}
	}


	@Transactional
	public void updatejizihao(String zsdm) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		 paraMap.put("nianyue", zsdm);
		 List<Jizihao> jis= jizihaoDao.findJizihao(paraMap);
		 if(jis.size()>0){
				Jizihao bean=jis.get(0);
				String dqjz=bean.getJizihao();
				String xjz=SysPropertiesUtil.subtract(dqjz, "1");
				double x=Double.valueOf(xjz);
				DecimalFormat df = new DecimalFormat("0000");
				String xin=String.valueOf(df.format(x));
				bean.setJizihao(xin);
				jizihaoDao.update(bean);				
			} 
		
	}





	
}
