package com.jshx.hisxrjbxxb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrjbxxb.dao.HisxrjbxxbDao;
import com.jshx.hisxrjbxxb.entity.Hisxrjbxxb;
import com.jshx.hisxrjbxxb.service.HisxrjbxxbService;

@Service("hisxrjbxxbService")
public class HisxrjbxxbServiceImpl extends BaseServiceImpl implements HisxrjbxxbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hisxrjbxxbDao")
	private HisxrjbxxbDao hisxrjbxxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hisxrjbxxbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrjbxxb getById(String id)
	{
		return hisxrjbxxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hisxrjbxxb hisxrjbxxb)
	{
		hisxrjbxxbDao.save(hisxrjbxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hisxrjbxxb hisxrjbxxb)
	{
		hisxrjbxxbDao.update(hisxrjbxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hisxrjbxxbDao.findHisxrjbxxb(paraMap);

		hisxrjbxxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hisxrjbxxbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hisxrjbxxb> query(Map<String, Object> map)
	{
		return hisxrjbxxbDao.findHisxrjbxxb(map);
	}
}
