package com.jshx.hisxrfymxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrfymxb.entity.Hisxrfymxb;
import com.jshx.hisxrfymxb.dao.HisxrfymxbDao;

@Component("hisxrfymxbDao")
public class HisxrfymxbDaoImpl extends BaseDaoImpl implements HisxrfymxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrfymxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrfymxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrfymxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrfymxb getById(String id)
	{
		return (Hisxrfymxb)this.getObjectById(Hisxrfymxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrfymxb hisxrfymxb)
	{
		hisxrfymxb.setId(null);
		this.saveOrUpdateObject(hisxrfymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrfymxb hisxrfymxb)
	{
		this.saveOrUpdateObject(hisxrfymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrfymxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrfymxb hisxrfymxb = (Hisxrfymxb)this.getObjectById(Hisxrfymxb.class, id);
		hisxrfymxb.setDelFlag(1);
		this.saveObject(hisxrfymxb);
	}
}
