package com.jshx.hisxlfymxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxlfymxb.entity.Hisxlfymxb;
import com.jshx.hisxlfymxb.dao.HisxlfymxbDao;

@Component("hisxlfymxbDao")
public class HisxlfymxbDaoImpl extends BaseDaoImpl implements HisxlfymxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxlfymxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxlfymxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxlfymxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxlfymxb getById(String id)
	{
		return (Hisxlfymxb)this.getObjectById(Hisxlfymxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxlfymxb hisxlfymxb)
	{
		hisxlfymxb.setId(null);
		this.saveOrUpdateObject(hisxlfymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxlfymxb hisxlfymxb)
	{
		this.saveOrUpdateObject(hisxlfymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxlfymxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxlfymxb hisxlfymxb = (Hisxlfymxb)this.getObjectById(Hisxlfymxb.class, id);
		hisxlfymxb.setDelFlag(1);
		this.saveObject(hisxlfymxb);
	}
}
