package com.jshx.hissfcjbxxb.web;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.fymxb.entity.Fymxb;
import com.jshx.fymxb.service.FymxbService;
import com.jshx.hissfcjbxxb.entity.DetailsInfo;
import com.jshx.hissfcjbxxb.entity.Hissfcjbxxb;
import com.jshx.hissfcjbxxb.service.HissfcjbxxbService;
import com.jshx.hissfjfjlb.entity.Hissfjfjlb;
import com.jshx.hissfjfjlb.service.HissfjfjlbService;
import com.jshx.hissfxxb.service.HissfxxbService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HissfcjbxxbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hissfcjbxxb hissfcjbxxb = new Hissfcjbxxb();

	/**
	 * 业务类
	 */
	@Autowired
	private HissfcjbxxbService hissfcjbxxbService;
	@Autowired
	private HissfjfjlbService hissfjfjlbService;
	@Autowired
	private FymxbService fymxbService;
	@Autowired
	private HissfxxbService hissfxxbService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryAcceptTimeStart;

	private Date queryAcceptTimeEnd;

	private Date queryCommit2TimeStart;

	private Date queryCommit2TimeEnd;

	private Date queryCommit3TimeStart;

	private Date queryCommit3TimeEnd;

	private Date queryArea1TimeStart;

	private Date queryArea1TimeEnd;

	private Date queryCommit1TimeStart;

	private Date queryCommit1TimeEnd;

	private Date queryArea2TimeStart;

	private Date queryArea2TimeEnd;

	private String acceptNo;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hissfcjbxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hissfcjbxxb.getAcceptNo()) && (0 < hissfcjbxxb.getAcceptNo().trim().length()))
			{
				paraMap.put("acceptNo", "%" + hissfcjbxxb.getAcceptNo().trim() + "%");
			}

			if (null != queryAcceptTimeStart)
			{
				paraMap.put("startAcceptTime", queryAcceptTimeStart);
			}

			if (null != queryAcceptTimeEnd)
			{
				paraMap.put("endAcceptTime", queryAcceptTimeEnd);
			}
			if ((null != hissfcjbxxb.getDwdm()) && (0 < hissfcjbxxb.getDwdm().trim().length()))
			{
				paraMap.put("dwdm", "%" + hissfcjbxxb.getDwdm().trim() + "%");
			}

			

			if ((null != hissfcjbxxb.getZsjxdbh()) && (0 < hissfcjbxxb.getZsjxdbh().trim().length()))
			{
				paraMap.put("zsjxdbh", "%" + hissfcjbxxb.getZsjxdbh().trim() + "%");
			}

			
			if ((null != hissfcjbxxb.getBuildDepartment()) && (0 < hissfcjbxxb.getBuildDepartment().trim().length()))
			{
				paraMap.put("buildDepartment", "%" + hissfcjbxxb.getBuildDepartment().trim() + "%");
			}
			
			if ((null != hissfcjbxxb.getCaseNo()) && (0 < hissfcjbxxb.getCaseNo().trim().length()))
			{
				paraMap.put("caseNo", "%" + hissfcjbxxb.getCaseNo().trim() + "%");
			}
			
			
			if ((null != hissfcjbxxb.getFileNo()) && (0 < hissfcjbxxb.getFileNo().trim().length()))
			{
				paraMap.put("fileNo", "%" + hissfcjbxxb.getFileNo().trim() + "%");
			}
			
			
			
			if ((null != hissfcjbxxb.getBuildItem()) && (0 < hissfcjbxxb.getBuildItem().trim().length()))
			{
				paraMap.put("buildItem", "%" + hissfcjbxxb.getBuildItem().trim() + "%");
			}
			
			
			if ((null != hissfcjbxxb.getBuildPlace()) && (0 < hissfcjbxxb.getBuildPlace().trim().length()))
			{
				paraMap.put("buildPlace", "%" + hissfcjbxxb.getBuildPlace().trim() + "%");
			}
			
			
			if ((null != hissfcjbxxb.getCheckArea()) && (0 < hissfcjbxxb.getCheckArea()))
			{
				paraMap.put("checkArea",  hissfcjbxxb.getCheckArea());
			}
			
			
			if ((null != hissfcjbxxb.getProcessType()) && (0 < hissfcjbxxb.getProcessType().trim().length()))
			{
				paraMap.put("processType", "%" + hissfcjbxxb.getProcessType().trim() + "%");
			}
			
	
			if ((null != hissfcjbxxb.getPolicyType()) && (0 < hissfcjbxxb.getPolicyType().trim().length()))
			{
				paraMap.put("policyType", "%" + hissfcjbxxb.getPolicyType().trim() + "%");
			}
			
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|establishmentCheckType|linkTelephone|acceptTime|buildPlace|isAuto|operator|infoFlag|infoProcess|messageNo|checkbackFlag|password1|checkbackTimes|caseNo|zhFlag|xxdjbh|printNum|commit1User|commit2User|commit2Time|commit3User|commit3Time|zsjxdbh|dwdm|departmentPlace|departmentType|buildItem|operatorname|zoneType1|tractType1|tractType2|policyType|guarantyFloor|guarantyEstablishmentType|guarantyDelay|linkMan|processType1|area1Time|passDepartment|licenceBase|licenceArchitecture|changeFloor|changeEstablishmentType|layoutPass|commit1Time|acceptNo|fileNo|processType2|area2Time|area1Operator|area2Operator|processType|checkArea|buildDepartment|zoneType2|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hissfcjbxxbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hissfcjbxxb) && (null != hissfcjbxxb.getId()))
			hissfcjbxxb = hissfcjbxxbService.getById(hissfcjbxxb.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hissfcjbxxb.setDeptId(this.getLoginUserDepartmentId());
			hissfcjbxxb.setDelFlag(0);
			hissfcjbxxbService.save(hissfcjbxxb);
		}
		else
		{
			hissfcjbxxbService.update(hissfcjbxxb);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hissfcjbxxb)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hissfcjbxxb中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hissfcjbxxbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getInfo()
	{
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("acceptNo", acceptNo);
		List<Hissfcjbxxb> cjbxxbs = hissfcjbxxbService.query(map);
		List<Hissfjfjlb> jfjlbs = hissfjfjlbService.query(map);
		List<Fymxb> fymxbs = fymxbService.query(map);
		List<String> sfxxb = hissfxxbService.findcd(map);
		for (Hissfjfjlb hissfjfjlb : jfjlbs)
		{
			String str = hissfjfjlb.getPayClass();
			switch (str)
			{
			case "1000":
				hissfjfjlb.setPayClass("缴");
				break;
			case "1100":
				hissfjfjlb.setPayClass("缴");
				break;
			case "2000":
				hissfjfjlb.setPayClass("缓");
				break;
			case "2100":
				hissfjfjlb.setPayClass("缓-缴");
				break;
			case "2200":
				hissfjfjlb.setPayClass("缓-免");
				break;
			case "2300":
				hissfjfjlb.setPayClass("缓-冲");
				break;
			case "2400":
				hissfjfjlb.setPayClass("再次缓");
				break;
			case "4000":
				hissfjfjlb.setPayClass("白蚁收费");
				break;
			case "4100":
				hissfjfjlb.setPayClass("白蚁收费");
				break;
			case "5000":
				hissfjfjlb.setPayClass("散装水泥");
				break;
			case "5100":
				hissfjfjlb.setPayClass("散装水泥");
				break;
			default:
				break;
			}
		}

		if (fymxbs != null && fymxbs.size() != 0)
		{
			String type = fymxbs.get(0).getTernType();
			if (type != null)
			{
				switch (type.trim())
				{
				case "1":
					fymxbs.get(0).setTernType("1|半年");
				case "2":
					fymxbs.get(0).setTernType("2|一年");
				case "3":
					fymxbs.get(0).setTernType("3|长期");
				case "4":
					fymxbs.get(0).setTernType("4|再一次");
				case "5":
					fymxbs.get(0).setTernType("5|在两次");
				case "6":
					fymxbs.get(0).setTernType("6|再三次");
				}
			}
		}

		DetailsInfo detailsInfo = new DetailsInfo();
		detailsInfo.setJfjlbs(jfjlbs);
		if (fymxbs != null && fymxbs.size() != 0)
			BeanUtils.copyProperties(fymxbs.get(0), detailsInfo);
		if (cjbxxbs != null && cjbxxbs.size() != 0)
			BeanUtils.copyProperties(cjbxxbs.get(0), detailsInfo);
		if(sfxxb.size()>0&&null !=sfxxb.get(0)){
			  double cd=Double.parseDouble(sfxxb.get(0));
			 double cd1= cd/10000;
			 double cd2=(double)Math.round(cd1*100)/100;
			 detailsInfo.setFee(String.valueOf(cd2));
		}
		setRequestAttribute("detailsInfo", detailsInfo);

		return SUCCESS;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hissfcjbxxb getHissfcjbxxb()
	{
		return this.hissfcjbxxb;
	}

	public void setHissfcjbxxb(Hissfcjbxxb hissfcjbxxb)
	{
		this.hissfcjbxxb = hissfcjbxxb;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQueryAcceptTimeStart()
	{
		return this.queryAcceptTimeStart;
	}

	public void setQueryAcceptTimeStart(Date queryAcceptTimeStart)
	{
		this.queryAcceptTimeStart = queryAcceptTimeStart;
	}

	public Date getQueryAcceptTimeEnd()
	{
		return this.queryAcceptTimeEnd;
	}

	public void setQueryAcceptTimeEnd(Date queryAcceptTimeEnd)
	{
		this.queryAcceptTimeEnd = queryAcceptTimeEnd;
	}

	public Date getQueryCommit2TimeStart()
	{
		return this.queryCommit2TimeStart;
	}

	public void setQueryCommit2TimeStart(Date queryCommit2TimeStart)
	{
		this.queryCommit2TimeStart = queryCommit2TimeStart;
	}

	public Date getQueryCommit2TimeEnd()
	{
		return this.queryCommit2TimeEnd;
	}

	public void setQueryCommit2TimeEnd(Date queryCommit2TimeEnd)
	{
		this.queryCommit2TimeEnd = queryCommit2TimeEnd;
	}

	public Date getQueryCommit3TimeStart()
	{
		return this.queryCommit3TimeStart;
	}

	public void setQueryCommit3TimeStart(Date queryCommit3TimeStart)
	{
		this.queryCommit3TimeStart = queryCommit3TimeStart;
	}

	public Date getQueryCommit3TimeEnd()
	{
		return this.queryCommit3TimeEnd;
	}

	public void setQueryCommit3TimeEnd(Date queryCommit3TimeEnd)
	{
		this.queryCommit3TimeEnd = queryCommit3TimeEnd;
	}

	public Date getQueryArea1TimeStart()
	{
		return this.queryArea1TimeStart;
	}

	public void setQueryArea1TimeStart(Date queryArea1TimeStart)
	{
		this.queryArea1TimeStart = queryArea1TimeStart;
	}

	public Date getQueryArea1TimeEnd()
	{
		return this.queryArea1TimeEnd;
	}

	public void setQueryArea1TimeEnd(Date queryArea1TimeEnd)
	{
		this.queryArea1TimeEnd = queryArea1TimeEnd;
	}

	public Date getQueryCommit1TimeStart()
	{
		return this.queryCommit1TimeStart;
	}

	public void setQueryCommit1TimeStart(Date queryCommit1TimeStart)
	{
		this.queryCommit1TimeStart = queryCommit1TimeStart;
	}

	public Date getQueryCommit1TimeEnd()
	{
		return this.queryCommit1TimeEnd;
	}

	public void setQueryCommit1TimeEnd(Date queryCommit1TimeEnd)
	{
		this.queryCommit1TimeEnd = queryCommit1TimeEnd;
	}

	public Date getQueryArea2TimeStart()
	{
		return this.queryArea2TimeStart;
	}

	public void setQueryArea2TimeStart(Date queryArea2TimeStart)
	{
		this.queryArea2TimeStart = queryArea2TimeStart;
	}

	public Date getQueryArea2TimeEnd()
	{
		return this.queryArea2TimeEnd;
	}

	public void setQueryArea2TimeEnd(Date queryArea2TimeEnd)
	{
		this.queryArea2TimeEnd = queryArea2TimeEnd;
	}

	public String getAcceptNo()
	{
		return acceptNo;
	}

	public void setAcceptNo(String acceptNo)
	{
		this.acceptNo = acceptNo;
	}

}
