package com.jshx.hishxjfjlb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxjfjlb.dao.HishxjfjlbDao;
import com.jshx.hishxjfjlb.entity.Hishxjfjlb;
import com.jshx.hishxjfjlb.service.HishxjfjlbService;

@Service("hishxjfjlbService")
public class HishxjfjlbServiceImpl extends BaseServiceImpl implements HishxjfjlbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hishxjfjlbDao")
	private HishxjfjlbDao hishxjfjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hishxjfjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxjfjlb getById(String id)
	{
		return hishxjfjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hishxjfjlb hishxjfjlb)
	{
		hishxjfjlbDao.save(hishxjfjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hishxjfjlb hishxjfjlb)
	{
		hishxjfjlbDao.update(hishxjfjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hishxjfjlbDao.findHishxjfjlb(paraMap);

		hishxjfjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hishxjfjlbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hishxjfjlb> query(Map<String, Object> map)
	{
		return hishxjfjlbDao.findHishxjfjlb(map);
	}
}
