package com.jshx.hishxhjkb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxhjkb.entity.Hishxhjkb;
import com.jshx.hishxhjkb.dao.HishxhjkbDao;

@Component("hishxhjkbDao")
public class HishxhjkbDaoImpl extends BaseDaoImpl implements HishxhjkbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxhjkbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxhjkb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxhjkbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxhjkb getById(String id)
	{
		return (Hishxhjkb)this.getObjectById(Hishxhjkb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxhjkb hishxhjkb)
	{
		hishxhjkb.setId(null);
		this.saveOrUpdateObject(hishxhjkb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxhjkb hishxhjkb)
	{
		this.saveOrUpdateObject(hishxhjkb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxhjkb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxhjkb hishxhjkb = (Hishxhjkb)this.getObjectById(Hishxhjkb.class, id);
		hishxhjkb.setDelFlag(1);
		this.saveObject(hishxhjkb);
	}
}
