package com.jshx.hishxfymxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxfymxb.entity.Hishxfymxb;
import com.jshx.hishxfymxb.dao.HishxfymxbDao;

@Component("hishxfymxbDao")
public class HishxfymxbDaoImpl extends BaseDaoImpl implements HishxfymxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxfymxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxfymxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxfymxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxfymxb getById(String id)
	{
		return (Hishxfymxb)this.getObjectById(Hishxfymxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxfymxb hishxfymxb)
	{
		hishxfymxb.setId(null);
		this.saveOrUpdateObject(hishxfymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxfymxb hishxfymxb)
	{
		this.saveOrUpdateObject(hishxfymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxfymxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxfymxb hishxfymxb = (Hishxfymxb)this.getObjectById(Hishxfymxb.class, id);
		hishxfymxb.setDelFlag(1);
		this.saveObject(hishxfymxb);
	}
}
