package com.jshx.hishxddfs.web;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hishxddfs.entity.Hishxddfs;
import com.jshx.hishxddfs.service.HishxddfsService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HishxddfsAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hishxddfs hishxddfs = new Hishxddfs();

	/**
	 * 业务类
	 */
	@Autowired
	private HishxddfsService hishxddfsService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryOperateTimeStart;

	private Date queryOperateTimeEnd;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	private String acceptNo;
	private String computerType;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hishxddfs)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hishxddfs.getDwdm()) && (0 < hishxddfs.getDwdm().trim().length()))
			{
				paraMap.put("dwdm", "%" + hishxddfs.getDwdm().trim() + "%");
			}

			if ((null != hishxddfs.getAcceptNo()) && (0 < hishxddfs.getAcceptNo().trim().length()))
			{
				paraMap.put("acceptNo", "%" + hishxddfs.getAcceptNo().trim() + "%");
			}

			if ((null != hishxddfs.getComputerType()) && (0 < hishxddfs.getComputerType().trim().length()))
			{
				paraMap.put("computerType", "%" + hishxddfs.getComputerType().trim() + "%");
			}

			if (null != queryOperateTimeStart)
			{
				paraMap.put("startOperateTime", queryOperateTimeStart);
			}

			if (null != queryOperateTimeEnd)
			{
				paraMap.put("endOperateTime", queryOperateTimeEnd);
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|dwdm|acceptNo|computerType|buildingNo|floor|area0001|area0002|area0003|area0004|area0005|area0007|area0006|operatorname|operateTime|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hishxddfsService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	public String list1() throws Exception
	{

		hishxddfs.setComputerType(computerType);
		hishxddfs.setAcceptNo(acceptNo);
		return "success";
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hishxddfs) && (null != hishxddfs.getId()))
			hishxddfs = hishxddfsService.getById(hishxddfs.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hishxddfs.setDeptId(this.getLoginUserDepartmentId());
			hishxddfs.setDelFlag(0);
			hishxddfsService.save(hishxddfs);
		}
		else
		{
			hishxddfsService.update(hishxddfs);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hishxddfs)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hishxddfs中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hishxddfsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hishxddfs getHishxddfs()
	{
		return this.hishxddfs;
	}

	public void setHishxddfs(Hishxddfs hishxddfs)
	{
		this.hishxddfs = hishxddfs;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQueryOperateTimeStart()
	{
		return this.queryOperateTimeStart;
	}

	public void setQueryOperateTimeStart(Date queryOperateTimeStart)
	{
		this.queryOperateTimeStart = queryOperateTimeStart;
	}

	public Date getQueryOperateTimeEnd()
	{
		return this.queryOperateTimeEnd;
	}

	public void setQueryOperateTimeEnd(Date queryOperateTimeEnd)
	{
		this.queryOperateTimeEnd = queryOperateTimeEnd;
	}

	public String getAcceptNo()
	{
		return acceptNo;
	}

	public void setAcceptNo(String acceptNo)
	{
		this.acceptNo = acceptNo;
	}

	public String getComputerType()
	{
		return computerType;
	}

	public void setComputerType(String computerType)
	{
		this.computerType = computerType;
	}

}
