package com.jshx.fsjktb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.dom4j.Element;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.quartz.NonTaxTask;
import com.neusoft.egov.utils.ZLibMimeUtil;

import http.UnitServiceServiceStub;

import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.fsjktb.entity.Fsjktb;
import com.jshx.fsjktb.service.FsjktbService;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.service.KpsjglService;

public class FsjktbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Fsjktb fsjktb = new Fsjktb();

	/**
	 * 业务类
	 */
	@Autowired
	private FsjktbService fsjktbService;
	    @Autowired
            private KpsjglService kpsjglService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryTbrqStart;

	private Date queryTbrqEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != fsjktb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if (null != queryTbrqStart){
				paraMap.put("startTbrq", queryTbrqStart);
			}

			if (null != queryTbrqEnd){
				paraMap.put("endTbrq", queryTbrqEnd);
			}
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|tbzsdw|tbsrxm|tbdsyh|zsdw|zsdwbm|qhm|skrqc|skrzh|skrkhh|xmbm|srxmmc|sfbz|tbrq|createTime|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = fsjktbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != fsjktb)&&(null != fsjktb.getId()))
			fsjktb = fsjktbService.getById(fsjktb.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			fsjktb.setDeptId(this.getLoginUserDepartmentId());
			fsjktb.setDelFlag(0);
			fsjktbService.save(fsjktb);
		}else{
			fsjktbService.update(fsjktb);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != fsjktb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到fsjktb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }
	
	//一建同步
        public String yijiantb() throws Exception{
                try{
                    List<Kpsjgl> lk= kpsjglService.findlkall(null);
                      Kpsjgl sk = null;
                      Kpsjgl zk = null;
                      if(null!=lk&&lk.size()>0){
                          for (Kpsjgl bean : lk) {
                             if("002".equals(bean.getGllb())){
                                 sk=kpsjglService.getById(bean.getId());
                             }
                             if("001".equals(bean.getGllb())){
                                 zk=kpsjglService.getById(bean.getId());
                             }
                         }
                      }
                     
                     
                         Fsjktb fs=new Fsjktb();
                         fs.setCreateTime(new Date());
                         fs.setDelFlag(0);                   
                     
                         //执收单位的基本信息getunitinfo
                         String interfaceName= SysPropertiesUtil.getProperty("interfaceName");
                         String interfacePwd=SysPropertiesUtil.getProperty("interfacePwd");
                         UnitServiceServiceStub stub = new UnitServiceServiceStub();
                         UnitServiceServiceStub.GetUnitInfo info = new  UnitServiceServiceStub.GetUnitInfo();
                         //接口对接用户名密码
                         info.setIn0(interfaceName);
                         info.setIn1(interfacePwd);
                         String result = stub.getUnitInfo(info).getGetUnitInfoReturn();
                         fs.setZsdwxx(result);
                         fs.setTbzsdw("0");
                         Element root =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(result));
                         String Zsdwbm=ZLibMimeUtil.getxmlnr(root,"/DATA/RECORD/dwbm");
                         String Zsdw=ZLibMimeUtil.getxmlnr(root,"/DATA/RECORD/dwmc");
                         fs.setZsdwbm(Zsdwbm);
                         fs.setZsdw(Zsdw);

                         //获取执收单位的收入项目信息ItemData
                         String Xmbm="";
                         String Srxmmc ="";
                         String sfbzsx="";
                         UnitServiceServiceStub stubb = new UnitServiceServiceStub();
                         UnitServiceServiceStub.GetItemData infoo = new  UnitServiceServiceStub.GetItemData();
                         //接口对接用户名密码
                         infoo.setIn0(interfaceName);
                         infoo.setIn1(interfacePwd);
                         String resultt = stubb.getItemData(infoo).getGetItemDataReturn();
                         fs.setSrxmxx(resultt);
                         fs.setTbsrxm("0");
                         Element roott =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(resultt));
                         List elements = roott.elements();
                         if(elements.size()>0){
                                    for (Iterator it = elements.iterator(); it.hasNext();) {
                                             Element elem = (Element) it.next();
                                             Element xmmc=(Element)elem.selectSingleNode("xmmc");
                                             if("城市基础设施配套费-市区".equals(xmmc.getText())){
                                                 Element xmbm=(Element)elem.selectSingleNode("xmbm");
                                                 Element biaozbun=(Element)elem.selectSingleNode("sfbzsx");
                                                  Xmbm=xmbm.getText();
                                                  Srxmmc =xmmc.getText();
                                                 sfbzsx =biaozbun.getText();//150
                                             }
                                            }
                         }
                         fs.setXmbm(Xmbm);
                         fs.setSrxmmc(Srxmmc);
                         fs.setSfbz(sfbzsx);
                         
                         
                         //代收银行信息getbankData
                         String Skrzh="";
                         String Skrkhh="";
                         String Skrqc="";
                         UnitServiceServiceStub sstub = new UnitServiceServiceStub();
                         UnitServiceServiceStub.GetBankData iinfo = new  UnitServiceServiceStub.GetBankData();
                         //接口对接用户名密码
                         iinfo.setIn0(interfaceName);
                         iinfo.setIn1(interfacePwd);
                         String rresult = sstub.getBankData(iinfo).getGetBankDataReturn();
                         fs.setDsyhxx(rresult);
                         fs.setTbdsyh("0");
                         Element rroot =ZLibMimeUtil.jiedian(ZLibMimeUtil.zLibDecode(rresult));
                         List eelements = rroot.elements();
                         if(eelements.size()>0){
                                    for (Iterator it = eelements.iterator(); it.hasNext();) {
                                             Element elem = (Element) it.next();
                                             Element khhmc=(Element)elem.selectSingleNode("khhmc");
                                             if("农行鼓楼支行".equals(khhmc.getText())){
                                                 Element zhzh=(Element)elem.selectSingleNode("zhzh");
                                                 Element zhmc=(Element)elem.selectSingleNode("zhmc");
                                                  Skrzh=zhzh.getText();
                                                  Skrkhh =khhmc.getText();
                                                  Skrqc =zhmc.getText();
                                             }
                                          }
                         }
                         fs.setSkrzh(Skrzh);
                         fs.setSkrkhh(Skrkhh);
                         fs.setSkrqc(Skrqc);
                 
                         
                                /*if(!sk.getZsdwbm().equals(Zsdwbm)){
                                     sk.setZsdwbm(Zsdwbm);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getZsdw().equals(Zsdw)){
                                     sk.setZsdw(Zsdw);
                                     sk.setBdjg(1L);
                                 }*/
                                 if(!sk.getXmbm().equals(Xmbm)){
                                     sk.setXmbm(Xmbm);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getSrxmmc().equals(Srxmmc)){
                                     sk.setSrxmmc(Srxmmc);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getSfbz().equals(sfbzsx)){
                                     sk.setSfbz(sfbzsx);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getSkrzh().equals(Skrzh)){
                                     sk.setSkrzh(Skrzh);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getSkrkhh().equals(Skrkhh)){
                                     sk.setSkrkhh(Skrkhh);
                                     sk.setBdjg(1L);
                                 }
                                 if(!sk.getKrqc().equals(Skrqc)){
                                     sk.setKrqc(Skrqc);
                                     sk.setBdjg(1L);
                                 }
                                 
                                 
                                 
//                       fs.setQhm(SysPropertiesUtil.getProperty("Qhm"));
                         fs.setQhm("320100");
                         sk.setUpdateTime(new Date());
                         kpsjglService.update(sk);
                         boolean isgx=false;
                         StringBuffer sb=new StringBuffer("");
                         
                              if(!sk.getZsdwbm().equals(zk.getZsdwbm())){
                                  isgx=true;
                              }
                              if(!sk.getZsdw().equals(zk.getZsdw())){
                                  isgx=true;
                                  sb.append("征收单位同步有差异.");
                              }
                              if(!sk.getXmbm().equals(zk.getXmbm())){
                                  isgx=true;
                                  sb.append("项目编码同步有差异.");
                              }
                              if(!sk.getSrxmmc().equals(zk.getSrxmmc())){
                                  sb.append("收款人项目名称有差异.");
                                  isgx=true;
                              }
                              if(!sk.getSfbz().equals(zk.getSfbz())){
                                  sb.append("收费标准有差异.");
                                  isgx=true;
                              }
                              if(!sk.getSkrzh().equals(zk.getSkrzh())){
                                  sb.append("收款人账号有差异.");
                                  isgx=true;
                              }
                              if(!sk.getSkrkhh().equals(zk.getSkrkhh())){
                                  sb.append("收款人开户行有差异.");
                                  isgx=true;
                              }
                              if(!sk.getKrqc().equals(zk.getKrqc())){
                                  sb.append("收款人全称有差异.");
                                  isgx=true;
                              }
                              if(isgx){
                                  zk.setUpdateTime(new Date());
                                  zk.setBdjg(1L);
                                  zk.setBzinfo(sb.toString());
                                  kpsjglService.update(zk);
                              }
                              fsjktbService.save(fs);
                         
                         
                 }catch(Exception e){
                         logger.error(e.getMessage());
                         System.out.println("超时或报错");
                         e.printStackTrace();
                         this.getResponse().getWriter().println("{\"result\":false}");
                 }
                 System.out.println("非税");
                 this.getResponse().getWriter().println("{\"result\":true}");
            return null;
        }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			fsjktbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Fsjktb getFsjktb(){
		return this.fsjktb;
	}

	public void setFsjktb(Fsjktb fsjktb){
		this.fsjktb = fsjktb;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryTbrqStart(){
		return this.queryTbrqStart;
	}

	public void setQueryTbrqStart(Date queryTbrqStart){
		this.queryTbrqStart = queryTbrqStart;
	}

	public Date getQueryTbrqEnd(){
		return this.queryTbrqEnd;
	}

	public void setQueryTbrqEnd(Date queryTbrqEnd){
		this.queryTbrqEnd = queryTbrqEnd;
	}


}
