package com.jshx.fawen.web;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.struts2.ServletActionContext;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.Fawen;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.entity.FawenReceiveinfo;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.fawen.service.FawenReceiveinfoService;
import com.jshx.fawen.service.FawenService;
import com.jshx.module.admin.entity.User;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class FawenAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String allFileName;
	private String originFileName;

	public String getQuerySendtimeStart()
	{
		return querySendtimeStart;
	}

	public void setQuerySendtimeStart(String querySendtimeStart)
	{
		this.querySendtimeStart = querySendtimeStart;
	}

	public String getQuerySendtimeEnd()
	{
		return querySendtimeEnd;
	}

	public void setQuerySendtimeEnd(String querySendtimeEnd)
	{
		this.querySendtimeEnd = querySendtimeEnd;
	}

	private List<FawenAttach> attach;
	private String uploadifyFileName;
	private String userIds;
	private String userNames;
	private String attachId;
	private String downFileName;// 文件下载下载文件文件名
	private String querySendtimeStart;

	private String querySendtimeEnd;

	public String getDownFileName()
	{
		return downFileName;
	}

	public void setDownFileName(String downFileName)
	{
		this.downFileName = downFileName;
	}

	public InputStream getDownFileStream()
	{
		return downFileStream;
	}

	public void setDownFileStream(InputStream downFileStream)
	{
		this.downFileStream = downFileStream;
	}

	private InputStream downFileStream;// 文件下载，被下载文件的输入流

	public String getAttachId()
	{
		return attachId;
	}

	public void setAttachId(String attachId)
	{
		this.attachId = attachId;
	}

	public String getUserNames()
	{
		return userNames;
	}

	public void setUserNames(String userNames)
	{
		this.userNames = userNames;
	}

	private static final Logger Logger = LoggerFactory.getLogger(FawenAction.class);

	public String getUserIds()
	{
		return userIds;
	}

	public void setUserIds(String userIds)
	{
		this.userIds = userIds;
	}

	/**
	 * 实体类
	 */
	private Fawen fawen = new Fawen();

	/**
	 * 业务类
	 */
	@Autowired
	private FawenService fawenService;

	@Autowired
	private FawenAttachService fawenAttachService;
	@Autowired
	private FawenReceiveinfoService fawenReceiveService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	private File uploadify;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date querySenddateStart;

	private Date querySenddateEnd;
	
	private String receiveStatus;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	/**
	 * 上传文件
	 * @return
	 */
	public String uploadify() throws IOException
	{
		int pos = uploadifyFileName.lastIndexOf(".");
		String extension = uploadifyFileName.substring(pos);
		String newName = UUID.randomUUID().toString().replaceAll("-", "").toLowerCase() + extension;
		 String cc = this.getRequest().getSession().getServletContext()
					.getRealPath(File.separator);
	        File ff = new File(cc);
	        String ab=ff.getParent();
	        String url=new File(ab).getParent()+File.separator+ "uploads";
//     String url = ServletActionContext.getServletContext().getRealPath("/" +SysPropertiesUtil.getProperty("filePath")) +File.separator + filename;
		url = url.replaceAll("\\\\", "/").trim();
		File newfile = new File(url);

		if (!newfile.exists())
		{
			newfile.mkdirs();
		}
		File destFile = new File(newfile + "/" + newName);
		copy(uploadify, destFile);
		getResponse().getWriter().println(newName);
		return NONE;
	}

	/**
	 * 复制文件
	 * @param src
	 * @param dst
	 */
	private void copy(File src, File dst)
	{
		try
		{
			InputStream in = null;
			OutputStream out = null;
			try
			{
				in = new BufferedInputStream(new FileInputStream(src));
				out = new BufferedOutputStream(new FileOutputStream(dst));
				byte[] buffer = new byte[1024];
				int byteRead = -1;
				/**
				 * 原来方法会复制缓冲池中多余数据，会导致上传的文件大于原文件大小
				 * GY-UPDATE
				while (in.read(buffer) > 0)
				{
					out.write(buffer);
				}
				*/
				while ((byteRead = in.read(buffer)) != -1)
				{
					out.write(buffer, 0, byteRead);
				}
				// 刷新此缓冲的输出流
				out.flush();
			} finally
			{
				if (in != null)
				{
					in.close();
				}
				if (out != null)
				{
					out.close();
				}
			}
		} catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	/**
	 * 下载附件文件
	 * @param filePath
	 * @return
	 */
	public String downloadFile()
	{

		if (StringUtil.isNotEmpty(attachId))
		{
			try
			{
				FawenAttach fawenAttach = fawenAttachService.getById(attachId);
				if (null != fawenAttach)
				{
					// 服务器路径,创建文件夹
					// 得到当前路径
					String filename = fawenAttach.getAttachpath();
//					String str = ServletActionContext.getServletContext().getRealPath("");
//					int i = "zhengshouWebRoot".length() + 2;
//					String path = str.substring(1, i);
//					String url = path + SysPropertiesUtil.getProperty("filePath") + File.separator + filename;
					 String cc = this.getRequest().getSession().getServletContext()
								.getRealPath(File.separator);
				        File ff = new File(cc);
				        String ab=ff.getParent();
				        String url=new File(ab).getParent()+File.separator+ "uploads" + File.separator + filename;
//                    String url = ServletActionContext.getServletContext().getRealPath("/" +SysPropertiesUtil.getProperty("filePath")) +File.separator + filename;
					url = url.replaceAll("\\\\", "/").trim();
					File file = new File(url);
					System.out.println(url);
					System.out.println(file.exists());
					// if (file.exists()) {
					downFileName = java.net.URLEncoder.encode(fawenAttach.getAttachname(), "UTF-8");
					// downFileStream =
					// ServletActionContext.getServletContext().getResourceAsStream("uploads/"
					// + filename);
					InputStream inputStream = null;
					byte[] contents = null;
					try
					{
						inputStream = new FileInputStream(file);
						contents = new byte[inputStream.available()];
						inputStream.read(contents);
					} catch (FileNotFoundException e)
					{

						e.printStackTrace();
					} catch (IOException e)
					{

						e.printStackTrace();
					}
					// downFileName = java.net.URLEncoder.encode(att
					// .getAttachname(), "UTF-8");
					downFileStream = getDownLoadFileStream(contents);
					// }
				}
			} catch (Exception ex)
			{
				logger.error(ex.toString());
				throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
			}
		}
		return SUCCESS;
	}
	public String downloadFile1()
	{
		
		if (StringUtil.isNotEmpty(attachId))
		{
			try
			{
				FawenAttach fawenAttach = fawenAttachService.getById(attachId);
				if (null != fawenAttach)
				{
					// 服务器路径,创建文件夹
					// 得到当前路径
					String filename = fawenAttach.getAttachpath();
//					String str = ServletActionContext.getServletContext().getRealPath("");
//					int i = "zhengshouWebRoot".length() + 2;
//					String path = str.substring(1, i);
//					String url = path + SysPropertiesUtil.getProperty("filePath") + File.separator + filename;
					 String cc = this.getRequest().getSession().getServletContext()
								.getRealPath(File.separator);
				        File ff = new File(cc);
				        String ab=ff.getParent();
				        String path=new File(ab).getParent()+File.separator+ "uploads" + File.separator + Constant.ZSLC_SDJD + File.separator+ filename;
					
//					String url = ServletActionContext.getServletContext().getRealPath("/" +SysPropertiesUtil.getProperty("filePath")) +File.separator + filename;
					String url = path.replaceAll("\\\\", "/").trim();
					File file = new File(url);
					System.out.println(url);
					System.out.println(file.exists());
					// if (file.exists()) {
					downFileName = java.net.URLEncoder.encode(fawenAttach.getAttachname(), "UTF-8");
					// downFileStream =
					// ServletActionContext.getServletContext().getResourceAsStream("uploads/"
					// + filename);
					InputStream inputStream = null;
					byte[] contents = null;
					try
					{
						inputStream = new FileInputStream(file);
						contents = new byte[inputStream.available()];
						inputStream.read(contents);
					} catch (FileNotFoundException e)
					{
						
						e.printStackTrace();
					} catch (IOException e)
					{
						
						e.printStackTrace();
					}
					// downFileName = java.net.URLEncoder.encode(att
					// .getAttachname(), "UTF-8");
					downFileStream = getDownLoadFileStream(contents);
					// }
				}
			} catch (Exception ex)
			{
				logger.error(ex.toString());
				throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
			}
		}
		return SUCCESS;
	}
	public String downloadFile2()
	{
	    
	    if (StringUtil.isNotEmpty(attachId))
	    {
	        try
	        {
	            FawenAttach fawenAttach = fawenAttachService.getById(attachId);
	            if (null != fawenAttach)
	            {
	                // 服务器路径,创建文件夹
	                // 得到当前路径
	                String filename = fawenAttach.getAttachpath();
//					String str = ServletActionContext.getServletContext().getRealPath("");
//					int i = "zhengshouWebRoot".length() + 2;
//					String path = str.substring(1, i);
//					String url = path + SysPropertiesUtil.getProperty("filePath") + File.separator + filename;
	                String cc = this.getRequest().getSession().getServletContext()
	                        .getRealPath(File.separator);
	                File ff = new File(cc);
	                String ab=ff.getParent();
	                String path=new File(ab).getParent()+File.separator+ "uploads" + File.separator + "CAD图" + File.separator+ filename;
	                
//					String url = ServletActionContext.getServletContext().getRealPath("/" +SysPropertiesUtil.getProperty("filePath")) +File.separator + filename;
	                String url = path.replaceAll("\\\\", "/").trim();
	                File file = new File(url);
	                System.out.println(url);
	                System.out.println(file.exists());
	                // if (file.exists()) {
	                downFileName = java.net.URLEncoder.encode(fawenAttach.getAttachname(), "UTF-8");
	                // downFileStream =
	                // ServletActionContext.getServletContext().getResourceAsStream("uploads/"
	                // + filename);
	                InputStream inputStream = null;
	                byte[] contents = null;
	                try
	                {
	                    inputStream = new FileInputStream(file);
	                    contents = new byte[inputStream.available()];
	                    inputStream.read(contents);
	                } catch (FileNotFoundException e)
	                {
	                    
	                    e.printStackTrace();
	                } catch (IOException e)
	                {
	                    
	                    e.printStackTrace();
	                }
	                // downFileName = java.net.URLEncoder.encode(att
	                // .getAttachname(), "UTF-8");
	                downFileStream = getDownLoadFileStream(contents);
	                // }
	            }
	        } catch (Exception ex)
	        {
	            logger.error(ex.toString());
	            throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
	        }
	    }
	    return SUCCESS;
	}

	/**
	 * 将文件转换成输入流，提供struts下载参数
	 * @param fileName 需要下载的文件路径
	 * @return
	 */
	public InputStream getDownLoadFileStream(byte[] bytes)
	{
		try
		{
			// 将得到的字节输出流转换成字节数组——>字节输入流
			downFileStream = new ByteArrayInputStream(bytes);
		} catch (Exception e)
		{
			return null;
		}
		return downFileStream;
	}

	/**
	 * 跳转到收文界面
	 */
	public String fawenListreceive()
	{
		return "success";
	}

	public void fawenListreceivelist()
	{
		List<Fawen> fawenList = new ArrayList<Fawen>();
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != fawen)
		{

			if (null != fawen.getTitle() && fawen.getTitle() != "" && (0 < fawen.getTitle().trim().length()))
			{
				paraMap.put("title", "%" + fawen.getTitle().trim() + "%");
			}

			if (null != querySendtimeStart && !("".equals(querySendtimeStart)) )
			{
				paraMap.put("startSendtime", querySendtimeStart);
			}

			if (null != querySendtimeEnd && !("".equals(querySendtimeEnd)))
			{
				paraMap.put("endSendtime", querySendtimeEnd);
			}


			if (null != fawen.getSenduserName() &&  fawen.getSenduserName() != "" && (0 <  fawen.getSenduserName().trim().length()))
			{
				paraMap.put("senduserName", "%" +  fawen.getSenduserName().trim() + "%");
			}
			if (null != receiveStatus && receiveStatus != "" && (0 < receiveStatus.trim().length()))
			{
				paraMap.put("receiveStatus",  receiveStatus.trim());
			}
		}

		User user = this.getLoginUser();

		paraMap.put("userId", user.getId());

		pagination = fawenService.findMailSendByPage(pagination, paraMap);
		List list = pagination.list;
		for (int i = 0; i < list.size(); i++)
		{
			Object[] obj = (Object[]) list.get(i);
			Fawen f = new Fawen();
			f.setId(obj[0].toString());
			f.setTitle(obj[1].toString());
			f.setSenduserName(obj[3].toString());
			f.setSenddate(obj[4].toString());
			f.setState(obj[5].toString());
			fawenList.add(f);
		}
		pagination.setList(fawenList);
		convObjectToJson(pagination, null);

	}

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		List<Fawen> fawenList = new ArrayList<Fawen>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		User user = this.getLoginUser();
		paraMap.put("senduserid", user.getId());
		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != fawen)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != fawen.getTitle()) && (0 < fawen.getTitle().trim().length()))
			{
				paraMap.put("title", "%" + fawen.getTitle().trim() + "%");
			}

			if (null != querySendtimeStart && !("".equals(querySendtimeStart)) )
			{
				paraMap.put("startSendtime", querySendtimeStart);
			}

			if (null != querySendtimeEnd && !("".equals(querySendtimeEnd)))
			{
				paraMap.put("endSendtime", querySendtimeEnd);
			}	

			if (null != fawen.getReceiveuserName() && fawen.getReceiveuserName() != "" && (0 < fawen.getReceiveuserName().trim().length()))
			{
				paraMap.put("receiveuserName", "%" + fawen.getReceiveuserName().trim() + "%");
			}
			if (null != receiveStatus && receiveStatus != "" && (0 < receiveStatus.trim().length()))
			{
				paraMap.put("receiveStatus",  receiveStatus.trim());
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|title|content|senduserid|senddate|senduserName|receiveuserName|state|receiveList|notReceiveList|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = fawenService.findByPage(pagination, paraMap);

//		List list = pagination.list;
//		for (int i = 0; i < list.size(); i++)
//		{
//			Object[] obj = (Object[]) list.get(i);
//			Fawen f = new Fawen();
//			f.setId(obj[0].toString());
//			f.setTitle(obj[1].toString());
//			f.setReceiveuserName((obj[3].toString()));
//			f.setSenddate(obj[4].toString());
//			if("1".equals(obj[5].toString())){
//				f.setState("未接收");
//			};			
//			if("2".equals(obj[5].toString())){
//				f.setState("已接收");
//			};
//			f.setReceiveuserName(obj[6].toString());
//			f.setNotReceiveList(obj[7].toString());
//			fawenList.add(f);
//		}
//		pagination.setList(fawenList);
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != fawen) && (null != fawen.getId()))
		{
			fawen = fawenService.getById(fawen.getId());
			Map<String, String> paramMap = new HashMap<String, String>();
			Map<String, String> paramMap1 = new HashMap<String, String>();
			paramMap.put("bizrowid", fawen.getId());
			attach = fawenAttachService.queryAttachListByTempleId(paramMap);
//			String loginid = this.getLoginUserId();
//			paramMap1.put("inneremailid", fawen.getId());
//			paramMap1.put("receiveuserid", loginid);
//			FawenReceiveinfo info = fawenReceiveService.oaReceiveinfo_recieverList(paramMap1);
//			info.setReceivestatus("2");
//			fawenReceiveService.update(info);
		}
		return VIEW;
	}

	
	public String view2() throws Exception
	{
		if ((null != fawen) && (null != fawen.getId()))
		{
			fawen = fawenService.getById(fawen.getId());
			Map<String, String> paramMap = new HashMap<String, String>();
			Map<String, String> paramMap1 = new HashMap<String, String>();
			paramMap.put("bizrowid", fawen.getId());
			attach = fawenAttachService.queryAttachListByTempleId(paramMap);
			String loginid = this.getLoginUserId();
			paramMap1.put("inneremailid", fawen.getId());
			paramMap1.put("receiveuserid", loginid);
			FawenReceiveinfo info = fawenReceiveService.oaReceiveinfo_recieverList(paramMap1);
			info.setReceivestatus("2");
			fawenReceiveService.update(info);
		
			if(fawen.getNotReceiveList()!=null){
				if(fawen.getNotReceiveList().indexOf(this.getLoginUser().getDisplayName())!=-1){
					String flag=fawen.getNotReceiveList().substring(fawen.getNotReceiveList().indexOf(this.getLoginUser().getDisplayName()));	
					if(flag.indexOf(",")==-1){
						String notReceiveList=fawen.getNotReceiveList().replace(this.getLoginUser().getDisplayName(), "");
						fawen.setNotReceiveList(notReceiveList);
					}else{
						String notReceiveList=fawen.getNotReceiveList().replace(this.getLoginUser().getDisplayName()+",", "");
						fawen.setNotReceiveList(notReceiveList);
					}
					
					if(fawen.getReceiveList()==null){
						String receiveList=this.getLoginUser().getDisplayName()+",";	
						fawen.setReceiveList(receiveList);
					}else{
						String receiveList=new StringBuffer(fawen.getReceiveList()).append(this.getLoginUser().getDisplayName()+",").toString();	
						fawen.setReceiveList(receiveList);
					}
					fawenService.update(fawen);
				}
			}
		}
		return VIEW;
	}
	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		if ((null != fawen) && (null != fawen.getId()))
		{
			fawen = fawenService.getById(fawen.getId());
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("bizrowid", fawen.getId());
			attach = fawenAttachService.queryAttachListByTempleId(paramMap);
		}
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			fawen.setDeptId(this.getLoginUserDepartmentId());
			fawen.setDelFlag(0);
			fawen.setSenddate(sdf.format(new Date()));
			fawen.setSenduserid(this.getLoginUserId());
			fawen.setSenduserName(this.getLoginUser().getDisplayName());
			fawen.setReceiveuserName(userNames);
			fawen.setNotReceiveList(userNames);
			fawenService.save(fawen);
			// 保存公告附件
			if (StringUtil.isNotNullAndNotEmpty(allFileName))
			{
				allFileName = allFileName.substring(0, allFileName.length() - 1);
				originFileName = originFileName.substring(0, originFileName.length() - 1);
				String[] arr = allFileName.split(",");
				String[] oriArr = originFileName.split(",");
				for (int i = 0; i < arr.length; i++)
				{
					FawenAttach att = new FawenAttach();
					att.setDelFlag(0);
					att.setAttachname(oriArr[i].trim());
					att.setAttachpath(arr[i].trim());
					att.setBizrowid(fawen.getId());
					att.setCreateTime(new Date());
					fawenAttachService.save(att);
				}

			}
			// 保存收件人相关信息
			String[] idArr = userIds.split(",");
			Collection<FawenReceiveinfo> visitList = new ArrayList<FawenReceiveinfo>();
			if (null != idArr && idArr.length > 0)
			{
				for (int i = 0; i < idArr.length; i++)
				{
					FawenReceiveinfo ori = new FawenReceiveinfo();
					ori.setInneremailid(fawen.getId());
					ori.setReceivestatus("1");
					ori.setReceiveuserid(idArr[i]);
					ori.setDelFlag(0);
					ori.setInfoIndex(i);// 设置内部排序号 GY-UPDATE 2014-05-16
					visitList.add(ori);
				}
				fawenReceiveService.saveCollection(visitList);
			}

		} catch (Exception e)
		{
			logger.error(e.toString());
			throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != fawen)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到fawen中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			fawenService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Fawen getFawen()
	{
		return this.fawen;
	}

	public void setFawen(Fawen fawen)
	{
		this.fawen = fawen;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQuerySenddateStart()
	{
		return this.querySenddateStart;
	}

	public void setQuerySenddateStart(Date querySenddateStart)
	{
		this.querySenddateStart = querySenddateStart;
	}

	public Date getQuerySenddateEnd()
	{
		return this.querySenddateEnd;
	}

	public void setQuerySenddateEnd(Date querySenddateEnd)
	{
		this.querySenddateEnd = querySenddateEnd;
	}

	public String getAllFileName()
	{
		return allFileName;
	}

	public void setAllFileName(String allFileName)
	{
		this.allFileName = allFileName;
	}

	public String getOriginFileName()
	{
		return originFileName;
	}

	public void setOriginFileName(String originFileName)
	{
		this.originFileName = originFileName;
	}

	public List<FawenAttach> getAttach()
	{
		return attach;
	}

	public void setAttach(List<FawenAttach> attach)
	{
		this.attach = attach;
	}

	public File getUploadify()
	{
		return uploadify;
	}

	public void setUploadify(File uploadify)
	{
		this.uploadify = uploadify;
	}

	public String getUploadifyFileName()
	{
		return uploadifyFileName;
	}

	public void setUploadifyFileName(String uploadifyFileName)
	{
		this.uploadifyFileName = uploadifyFileName;
	}

	public String getReceiveStatus() {
		return receiveStatus;
	}

	public void setReceiveStatus(String receiveStatus) {
		this.receiveStatus = receiveStatus;
	}

	
	
}
