package com.jshx.fawen.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.dao.FawenAttachDao;
import com.jshx.fawen.entity.Attachinfo;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.xmxxb.entity.Xmxxb;


@Service("fawenAttachService")
public class FawenAttachServiceImpl extends BaseServiceImpl implements FawenAttachService
{
	/**
	 * Dao类
	 */
	@Resource
	@Qualifier("fawenAttachDao")
	private FawenAttachDao fawenAttachDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return fawenAttachDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	@Transactional
	public FawenAttach getById(String id)
	{
		return fawenAttachDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(FawenAttach oaAttach)
	{
		fawenAttachDao.save(oaAttach);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(FawenAttach oaAttach)
	{
		fawenAttachDao.update(oaAttach);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=fawenAttachDao.findOaAttach(paraMap);
		
		fawenAttachDao.removeAll(objects);
	}

	
	@Transactional
	public void delete(Map<String, Object> paramsMap) {
		// TODO Auto-generated method stub
		List objects=fawenAttachDao.findOaAttach(paramsMap);
		fawenAttachDao.removeAll(objects);
	}
	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
			    	fawenAttachDao.deleteWithFlag(id);
			}
		}
	}
	
	
	
	
	
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 * 
	 */
	public List<FawenAttach> queryShouwenAttachListByTempleId(
			Map<String, String> paramsMap) {
		// TODO Auto-generated method stub
		return fawenAttachDao.queryShouwenAttachListByTempleId(paramsMap);
	}
	
	/**
	 * 查询附件信息
	 * @param map 参数条件
	 * @return
	 */
	@Transactional
	public List findOaAttachByMap(Map map)
	{
		return fawenAttachDao.findOaAttach(map);
	}
	/**
	 * 根据模板ID取相应的附件
	 * @param paramsMap
	 * @return
	 * 
	 */
	@Override
	public List<FawenAttach> queryAttachListByTempleId(Map<String, String> paramsMap) {
	
		return fawenAttachDao.queryAttachListByTempleId(paramsMap);
	}
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 * 
	 */
	@Override
	public List<FawenAttach> queryFawenAttachListByTempleId(Map<String, String> paramsMap) {
		return fawenAttachDao.queryFawenAttachListByTempleId(paramsMap);
	}

	@Override
	public String getByFscl(String fscl,String xmtype) {
		String clno="";
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("fscl", fscl);
		paraMap.put("xmtype", xmtype);
		Attachinfo attachinfo =	(Attachinfo) fawenAttachDao.findObjectByFieldsMap(Attachinfo.class, paraMap);
		if(attachinfo!=null)
		{
			clno =attachinfo.getClno();
		}
		return clno;
	}
	
	@Override
	public String getByFscl(String fscl) {
		String clno="";
		Map<String, String> paraMap = new HashMap<String, String>();
		paraMap.put("fscl", fscl);
		Attachinfo attachinfo =	(Attachinfo) fawenAttachDao.findObjectByFieldsMap(Attachinfo.class, paraMap);
		if(attachinfo!=null)
		{
			clno =attachinfo.getClno();
		}
		return clno;
	}
}
