package com.jshx.epQysq.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.StringUtils;
import org.openwebflow.util.ProcessDefinitionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.epQysq.dao.ActivitiControllerDao;
import com.jshx.epQysq.service.ActivitiController;

@Service("activitiController")
public class ActivitiControllerImpl extends BaseServiceImpl implements ActivitiController {

	@Autowired
	protected RuntimeService runtimeService;

	@Autowired
	protected TaskService taskService;

	@Autowired
	protected IdentityService identityService;

	@Autowired
	private RepositoryService repositoryService;

	@Autowired
	private HistoryService historyService;

	@Autowired
	@Qualifier("activitiControllerDao")
	private ActivitiControllerDao activitiControllerDao;

	@Autowired
	private ProcessEngine _processEngine;

	@Override
	@Transactional
	public String startProcessInstance(String key, String rowId, String userId, Map<String, Object> variables) {
		// TODO Auto-generated method stub
		this.identityService.setAuthenticatedUserId(userId);
		ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, rowId, variables);
		if (processInstance != null) {
			return processInstance.getProcessInstanceId();
		} else {
			return "";
		}
	}

	@Override
	@Transactional
	public void passProcess(String taskId, String comment, Map<String, Object> variables) {
		// TODO Auto-generated method stub
		if (null != comment && !comment.isEmpty())
			taskService.addComment(taskId, null, comment);// comment为批注内容
		taskService.complete(taskId, variables);
	}

	@Override
	@Transactional
	public void endProcess(String processInstanceId) {
		// TODO Auto-generated method stub
		runtimeService.deleteProcessInstance(processInstanceId, "人工终止");
	}

	/**
	 * 跳转至指定活动节点
	 * 
	 * @param targetTaskDefinitionKey
	 * @throws Exception
	 */
	@Transactional
	public void jump(String targetTaskDefinitionKey, String _processId) throws Exception {
		TaskEntity currentTask = (TaskEntity) _processEngine.getTaskService().createTaskQuery()
				.processInstanceId(_processId).singleResult();
		jump(currentTask, targetTaskDefinitionKey);
		Map paraMap = new HashMap();
		paraMap.put("SqlId", "updateEXECUTION");
		paraMap.put("targetTaskDefinitionKey", _processId);
		paraMap.put("currentTaskEntity", targetTaskDefinitionKey);
		activitiControllerDao.updateBySql(paraMap);
	}

	/**
	 * 
	 * @param currentTaskEntity
	 *            当前任务节点
	 * @param targetTaskDefinitionKey
	 *            目标任务节点（在模型定义里面的节点名称）
	 * @throws Exception
	 */
	private void jump(final TaskEntity currentTaskEntity, String targetTaskDefinitionKey) throws Exception {
		final ActivityImpl activity = ProcessDefinitionUtils.getActivity(_processEngine,
				currentTaskEntity.getProcessDefinitionId(), targetTaskDefinitionKey);

		final ExecutionEntity execution = (ExecutionEntity) _processEngine.getRuntimeService().createExecutionQuery()
				.executionId(currentTaskEntity.getExecutionId()).singleResult();

		final TaskService taskService = _processEngine.getTaskService();

		// 包装一个Command对象
		((RuntimeServiceImpl) _processEngine.getRuntimeService()).getCommandExecutor()
				.execute(new Command<java.lang.Void>() {
					@Override
					public Void execute(CommandContext commandContext) {
						// 创建新任务
						execution.setActivity(activity);
						execution.executeActivity(activity);

						// 删除当前的任务
						// 不能删除当前正在执行的任务，所以要先清除掉关联
						currentTaskEntity.setExecutionId(null);
						taskService.saveTask(currentTaskEntity);
						taskService.deleteTask(currentTaskEntity.getId(), true);

						return null;
					}
				});
	}

	@Override
	public Pagination findBySqlId(Pagination pagination, Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return activitiControllerDao.findBySqlId(pagination, paraMap);
	}

	@Override
	@Transactional
	public void delegate(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		taskService.setAssignee(paraMap.get("taskId").toString(), paraMap.get("userId").toString());
	}

	@Override
	@Transactional
	public void suspendOrActivateProcessDefinition(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		if (paraMap.get("flag").toString().equals("0")) {
		} else {
		}
	}

	@Override
	public List<Map<String, Object>> buttonList(String taskId) {
		// TODO Auto-generated method stub
		List<Map<String, Object>> transNames = new ArrayList<Map<String, Object>>();
		Map<String, Object> map = null;
		Task task = this.taskService.createTaskQuery().taskId(taskId).singleResult();
		String excId = task.getExecutionId();
		ExecutionEntity execution = (ExecutionEntity) runtimeService.createExecutionQuery().executionId(excId)
				.singleResult();
		String activitiId = execution.getActivityId();

		ProcessDefinitionEntity pd = (ProcessDefinitionEntity) repositoryService
				.getProcessDefinition(task.getProcessDefinitionId());
		// 4.通过活动的ID在流程定义中找到对应的活动对象
		ActivityImpl activity = pd.findActivity(activitiId);
		// 5.通过活动对象找当前活动的所有出口
		List<PvmTransition> transitions = activity.getOutgoingTransitions();
		// 6.提取所有出口的名称，封装成集合
		for (PvmTransition trans : transitions) {
			map = new HashMap<String, Object>();
			String transName = (String) trans.getProperty("name");

			if (StringUtils.isNotBlank(transName)) {
				map.put("transName", transName);
				String str = (String) trans.getProperty("conditionText");
				map.put("id", str.substring(15, str.length() - 2));
				transNames.add(map);
			}
		}
		return transNames;
	}

	@Override
	public List<Map<String, Object>> instanceDiagram(String processDefinitionId) {
		// TODO Auto-generated method stub
		List<HistoricActivityInstance> hais = historyService.createHistoricActivityInstanceQuery()
				// 过滤条件
				.processInstanceId(processDefinitionId)
				// 排序条件
				.orderByHistoricActivityInstanceStartTime().asc()
				// 执行查询
				.list();

		Map<String, Object> map = null;
		List<Map<String, Object>> hlist = new ArrayList<Map<String, Object>>();
		Date claimTime = null;
		for (HistoricActivityInstance hai : hais) {
			map = new HashMap<String, Object>();

			map = new HashMap<String, Object>();
			map.put("name", hai.getActivityName());
			map.put("startTime", hai.getStartTime());
			map.put("endTime", hai.getEndTime());
			map.put("assignee", hai.getAssignee());

			List<Comment> comments = taskService.getTaskComments(hai.getTaskId());
			if (null != comments && comments.size() > 0) {
				map.put("remark", comments.get(0).getFullMessage());
			} else {
				map.put("remark", "");
			}
			List<Attachment> list = taskService.getTaskAttachments(hai.getTaskId());

			map.put("attList", list);

			hlist.add(map);
			if (hai.getActivityId().equals("usertask1") || hai.getActivityId().equals("usertask2")) {
				if (null == claimTime)
					hlist.remove(hlist.size() - 1);
			}
			claimTime = null;
		}
		return hlist;
	}

	@Override
	@Transactional
	public void createAttachment(String attachmentType, String taskId, String processInstanceId, String attachmentName,
			String url) {
		taskService.createAttachment(attachmentType, taskId, processInstanceId, attachmentName, "", url);
	}

}
